/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal;

import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.base.Preconditions;
import com.sonatype.analytics.AnalyticsMarker;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.security.SecuritySystem;
import org.sonatype.nexus.selector.SelectorConfiguration;
import org.sonatype.nexus.selector.SelectorManager;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class ContentSelectorAnalytics
implements AnalyticsMarker {
    private final SelectorManager selectorManager;
    private final SecuritySystem securitySystem;

    @Inject
    public ContentSelectorAnalytics(SelectorManager selectorManager, SecuritySystem securitySystem) {
        this.selectorManager = (SelectorManager)Preconditions.checkNotNull((Object)selectorManager);
        this.securitySystem = (SecuritySystem)Preconditions.checkNotNull((Object)securitySystem);
    }

    @CachedGauge(name="nexus.analytics.content_selector_count", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public long count() {
        return this.selectorManager.browse().size();
    }

    @CachedGauge(name="nexus.analytics.content_selector_in_use_count", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public long inUseCount() {
        return this.securitySystem.listPrivileges().stream().filter(privilege -> "repository-content-selector".equals(privilege.getType())).map(privilege -> privilege.getPrivilegeProperty("contentSelector")).distinct().count();
    }

    @CachedGauge(name="nexus.analytics.content_selector_with_coordinates_count", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public long coordinatesCount() {
        return this.selectorManager.browse().stream().filter(SelectorConfiguration::hasCoordinates).count();
    }

    @CachedGauge(name="nexus.analytics.content_selector_with_coordinates_in_use_count", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public long coordinatesInUseCount() {
        return this.securitySystem.listPrivileges().stream().filter(privilege -> "repository-content-selector".equals(privilege.getType())).map(privilege -> privilege.getPrivilegeProperty("contentSelector")).map(arg_0 -> ((SelectorManager)this.selectorManager).findByName(arg_0)).filter(Optional::isPresent).map(Optional::get).filter(SelectorConfiguration::hasCoordinates).count();
    }

    @CachedGauge(name="nexus.analytics.content_selector_jexl_count", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public long jexlCount() {
        return this.selectorManager.browse().stream().filter(selectorConfiguration -> "jexl".equals(selectorConfiguration.getType())).count();
    }
}

