/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal;

import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.analytics.AnalyticsMarker;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.CleanupDryRunEvent;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class CleanupDryRunAnalytics
extends ComponentSupport
implements AnalyticsMarker,
EventAware {
    private final Queue<Map<String, Object>> dryRunCalls = new ConcurrentLinkedQueue<Map<String, Object>>();

    @CachedGauge(name="nexus.analytics.cleanup_dry_run_min_execution_time", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public Long cleanupDryRunMinExecutionTime() {
        if (this.dryRunCalls.isEmpty()) {
            return 0L;
        }
        return this.dryRunCalls.stream().map(x -> {
            Long finishedAt = Long.parseLong(String.valueOf(x.get("finishedAt_in_milliseconds")));
            Long startedAt = Long.parseLong(String.valueOf(x.get("startedAt_in_milliseconds")));
            return finishedAt - startedAt;
        }).mapToLong(Long::longValue).summaryStatistics().getMin();
    }

    @CachedGauge(name="nexus.analytics.cleanup_dry_run_avg_execution_time", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public Long cleanupDryRunAvgExecutionTime() {
        if (this.dryRunCalls.isEmpty()) {
            return 0L;
        }
        return Double.valueOf(this.dryRunCalls.stream().map(x -> {
            Long finishedAt = Long.parseLong(String.valueOf(x.get("finishedAt_in_milliseconds")));
            Long startedAt = Long.parseLong(String.valueOf(x.get("startedAt_in_milliseconds")));
            return finishedAt - startedAt;
        }).mapToLong(Long::longValue).summaryStatistics().getAverage()).longValue();
    }

    @CachedGauge(name="nexus.analytics.cleanup_dry_run_max_execution_time", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public Long cleanupDryRunMaxExecutionTime() {
        if (this.dryRunCalls.isEmpty()) {
            return 0L;
        }
        return this.dryRunCalls.stream().map(x -> {
            Long finishedAt = Long.parseLong(String.valueOf(x.get("finishedAt_in_milliseconds")));
            Long startedAt = Long.parseLong(String.valueOf(x.get("startedAt_in_milliseconds")));
            return finishedAt - startedAt;
        }).mapToLong(Long::longValue).summaryStatistics().getMax();
    }

    @CachedGauge(name="nexus.analytics.cleanup_dry_run_count", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public Integer cleanupDryRunCount() {
        return this.dryRunCalls.size();
    }

    @Override
    public void reset() {
        this.dryRunCalls.clear();
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(CleanupDryRunEvent event) {
        this.dryRunCalls.add(event.getReference());
    }
}

