/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.analytics.AnalyticsReportService;
import com.sonatype.analytics.internal.AnalyticsReport;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationLicense;
import org.sonatype.nexus.common.app.FeatureFlag;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class AnalyticsReportServiceImpl
extends ComponentSupport
implements AnalyticsReportService {
    @VisibleForTesting
    static final String OSS_ANALYTICS_URL = "https://nxrm.telemetry.sonatype.com/production/oss/ingest";
    @VisibleForTesting
    static final String PROD_ANALYTICS_URL = "https://nxrm.telemetry.sonatype.com/production/ingest";
    @VisibleForTesting
    public static final String DEV_ANALYTICS_URL = "https://nxrm-dev.telemetry.sonatype.com/dev/ingest";
    @VisibleForTesting
    static final String PRO_STARTER_ANALYTICS_URL = "https://nxrm.telemetry.sonatype.com/production/pro-starter/ingest";
    @VisibleForTesting
    static final String DEV_PRO_STARTER_ANALYTICS_URL = "https://nxrm-dev.telemetry.sonatype.com/dev/pro-starter/ingest";
    @VisibleForTesting
    String overrideUploadUrl;
    private final boolean autoSetEnvironment;
    private final Provider<ApplicationLicense> applicationLicense;
    private final Provider<CloseableHttpClient> httpClientProvider;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Inject
    public AnalyticsReportServiceImpl(Provider<ApplicationLicense> applicationLicense, Provider<CloseableHttpClient> httpClientProvider, @Named(value="${nexus.analytics.upload.url}") @Nullable @Named(value="${nexus.analytics.upload.url}") @Nullable String overrideUploadUrl, @Named(value="${nexus.analytics.upload.autoSetEnvironment:-true}") @Named(value="${nexus.analytics.upload.autoSetEnvironment:-true}") boolean autoSetEnvironment) {
        this.applicationLicense = (Provider)Preconditions.checkNotNull(applicationLicense);
        this.httpClientProvider = httpClientProvider;
        this.overrideUploadUrl = overrideUploadUrl;
        this.autoSetEnvironment = autoSetEnvironment;
    }

    public void start() {
    }

    public void stop() {
    }

    @Override
    public void report(AnalyticsReport analyticsReport) {
        Preconditions.checkNotNull((Object)analyticsReport);
        String submissionUrl = this.getUrl();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (CloseableHttpClient client = (CloseableHttpClient)this.httpClientProvider.get();){
                HttpPost post = new HttpPost(submissionUrl);
                String json = this.objectMapper.writeValueAsString(analyticsReport.getValues());
                this.log.debug("Uploading analytics to {}", (Object)submissionUrl);
                this.log.debug("Uploading analytics json {}", (Object)json);
                post.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
                Throwable throwable2 = null;
                Object var9_13 = null;
                try (CloseableHttpResponse response = client.execute((HttpUriRequest)post);){
                    if (204 != response.getStatusLine().getStatusCode()) {
                        HttpEntity entity = response.getEntity();
                        String body = entity != null ? EntityUtils.toString((HttpEntity)entity) : "";
                        this.log.warn("Failed to upload analytics to {}. Cause {} {}", new Object[]{submissionUrl, response.getStatusLine().getStatusCode(), body});
                    } else {
                        this.log.info("Uploaded analytics successfully.");
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.warn("Failed to upload analytics to {} {}", new Object[]{submissionUrl, e.getMessage(), this.log.isDebugEnabled() ? e : null});
        }
    }

    @VisibleForTesting
    String getUrl() {
        if (this.overrideUploadUrl != null) {
            return this.overrideUploadUrl;
        }
        ApplicationLicense license = (ApplicationLicense)this.applicationLicense.get();
        if (!license.isValid()) {
            return OSS_ANALYTICS_URL;
        }
        String contact = license.getAttributes().getOrDefault(ApplicationLicense.Attributes.CONTACT_EMAIL.getKey(), "").toString().toLowerCase();
        if (contact.endsWith("@sonatype.com") && this.autoSetEnvironment) {
            if (AnalyticsReportServiceImpl.isProStarterLicense(license)) {
                return DEV_PRO_STARTER_ANALYTICS_URL;
            }
            return DEV_ANALYTICS_URL;
        }
        if (AnalyticsReportServiceImpl.isProStarterLicense(license)) {
            return PRO_STARTER_ANALYTICS_URL;
        }
        return PROD_ANALYTICS_URL;
    }

    @Override
    public void overrideUrl(String url) {
        this.overrideUploadUrl = url;
    }

    private static boolean isProStarterLicense(ApplicationLicense license) {
        List features = license.getAttributes().getOrDefault(ApplicationLicense.Attributes.FEATURES.getKey(), Collections.emptyList());
        return features.contains("NexusStarter");
    }
}

