/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.sonatype.analytics.AnalyticsLicenseChecker;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationLicense;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.hash.Hashes;
import org.sonatype.nexus.common.text.Strings2;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class AnalyticsLicenseCheckerImpl
extends ComponentSupport
implements AnalyticsLicenseChecker {
    private static final boolean DEFAULT_AUTHORIZATION = false;
    private final ObjectMapper mapper = new ObjectMapper();
    private String licenseCheckUrl;
    private final ApplicationLicense applicationLicense;
    private final Provider<CloseableHttpClient> httpClientProvider;
    private LocalDateTime authorizationValidUntil = null;
    private Boolean authorization = null;

    @Inject
    public AnalyticsLicenseCheckerImpl(@Named(value="${nexus.analytics.licenseCheck.url:-https://license.telemetry.sonatype.com/production}") @Named(value="${nexus.analytics.licenseCheck.url:-https://license.telemetry.sonatype.com/production}") String licenseCheckUrl, ApplicationLicense applicationLicense, Provider<CloseableHttpClient> httpClientProvider) {
        this.licenseCheckUrl = (String)Preconditions.checkNotNull((Object)licenseCheckUrl);
        this.applicationLicense = (ApplicationLicense)Preconditions.checkNotNull((Object)applicationLicense);
        this.httpClientProvider = (Provider)Preconditions.checkNotNull(httpClientProvider);
    }

    @Override
    public boolean analyticsSubmissionAuthorized() {
        LocalDateTime now = LocalDateTime.now();
        if (!this.applicationLicense.isInstalled()) {
            return true;
        }
        if (this.isProStarterLicense()) {
            return true;
        }
        if (this.authorization != null && now.isBefore(this.authorizationValidUntil)) {
            return this.authorization;
        }
        LicenseCheckerServiceResponse licenseCheckerServiceResponse = this.checkLicense(this.hashedLicenseFingerprint());
        if (licenseCheckerServiceResponse != null) {
            this.authorizationValidUntil = now.plusDays(licenseCheckerServiceResponse.nextCheckDays);
            this.authorization = licenseCheckerServiceResponse.enabled;
            this.log.debug("received license enabled {} valid until {}", (Object)this.authorization, (Object)this.authorizationValidUntil);
            return this.authorization;
        }
        return false;
    }

    private boolean isProStarterLicense() {
        List features = this.applicationLicense.getAttributes().getOrDefault(ApplicationLicense.Attributes.FEATURES.getKey(), Collections.emptyList());
        return features.contains("NexusStarter");
    }

    @Override
    public void clearCache() {
        this.authorizationValidUntil = null;
        this.authorization = null;
    }

    @Override
    public void updateUrl(String url) {
        this.licenseCheckUrl = url;
    }

    private String hashedLicenseFingerprint() {
        String nexusFingerprint;
        block3: {
            try {
                nexusFingerprint = this.applicationLicense.getFingerprint();
                if (nexusFingerprint != null) break block3;
                return null;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        HashCode hashCode = Hashes.hash((HashAlgorithm)HashAlgorithm.SHA512, (InputStream)new ByteArrayInputStream(Strings2.utf8((String)nexusFingerprint)));
        return hashCode.toString();
    }

    /*
     * Loose catch block
     */
    private LicenseCheckerServiceResponse checkLicense(String fingerprint) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (CloseableHttpClient httpClient = (CloseableHttpClient)this.httpClientProvider.get();){
                LicenseCheckerServiceResponse licenseCheckerServiceResponse;
                CloseableHttpResponse response;
                Throwable throwable2;
                block21: {
                    URI uri = UriBuilder.fromUri((String)this.licenseCheckUrl).queryParam("fingerprint", new Object[]{fingerprint}).build(new Object[0]);
                    this.log.debug("Submitting license check for fingerprint {} to {}", (Object)fingerprint, (Object)uri);
                    HttpGet get = new HttpGet(uri);
                    throwable2 = null;
                    Object var8_12 = null;
                    response = httpClient.execute((HttpUriRequest)get);
                    licenseCheckerServiceResponse = (LicenseCheckerServiceResponse)this.mapper.readValue(response.getEntity().getContent(), LicenseCheckerServiceResponse.class);
                    if (response == null) break block21;
                    response.close();
                }
                return licenseCheckerServiceResponse;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (response != null) {
                                response.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.debug("unable to check license from remote", (Throwable)e);
            return null;
        }
    }

    private static class LicenseCheckerServiceResponse {
        public boolean enabled;
        public int nextCheckDays;

        private LicenseCheckerServiceResponse() {
        }
    }
}

