/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal;

import com.codahale.metrics.annotation.CachedGauge;
import com.sonatype.analytics.AnalyticsMarker;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
@Named
@Singleton
public class AnalyticsDockerPreferencesUsage
implements AnalyticsMarker {
    private static final String PRO_LICENSE = "PRO";
    private static final String DOCKER_FORMAT = "docker";
    private static final String DOCKER_CONFIGURATION_SUBDOMAIN_KEY = "subdomain";
    private static final String DOCKER_CONFIGURATION_HTTP_PORT_KEY = "httpPort";
    private static final String DOCKER_CONFIGURATION_HTTPS_PORT_KEY = "httpsPort";
    private final RepositoryManager repositoryManager;
    private final boolean subdomainEnabled;

    @Inject
    public AnalyticsDockerPreferencesUsage(ApplicationVersion applicationVersion, RepositoryManager repositoryManager) {
        this.repositoryManager = Objects.requireNonNull(repositoryManager);
        this.subdomainEnabled = PRO_LICENSE.equals(applicationVersion.getEdition());
    }

    @CachedGauge(name="nexus.analytics.docker_preferences_usage_subdomain_count", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public long subdomain() {
        if (!this.subdomainEnabled) {
            return 0L;
        }
        return this.getCountByConfigurationKey(DOCKER_CONFIGURATION_SUBDOMAIN_KEY);
    }

    @CachedGauge(name="nexus.analytics.docker_preferences_usage_http_count", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public long http() {
        return this.getCountByConfigurationKey(DOCKER_CONFIGURATION_HTTP_PORT_KEY);
    }

    @CachedGauge(name="nexus.analytics.docker_preferences_usage_https_count", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public long https() {
        return this.getCountByConfigurationKey(DOCKER_CONFIGURATION_HTTPS_PORT_KEY);
    }

    private long getCountByConfigurationKey(String dockerConfigurationKey) {
        return StreamSupport.stream(this.repositoryManager.browse().spliterator(), false).filter(repository -> DOCKER_FORMAT.equals(repository.getFormat().getValue())).filter(repository -> {
            Configuration configuration = repository.getConfiguration();
            NestedAttributesMap docker = configuration.attributes(DOCKER_FORMAT);
            Object configurationValue = docker.get(dockerConfigurationKey);
            return Objects.nonNull(configurationValue);
        }).count();
    }
}

