/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.webhooks;

import com.codahale.metrics.annotation.Gauge;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.InternalAccessible;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.thread.NexusThreadFactory;
import org.sonatype.nexus.webhooks.Webhook;
import org.sonatype.nexus.webhooks.WebhookRequest;
import org.sonatype.nexus.webhooks.WebhookRequestSendEvent;
import org.sonatype.nexus.webhooks.WebhookService;

@Named
@Singleton
public class WebhookServiceImpl
extends ComponentSupport
implements WebhookService,
EventAware,
EventAware.Asynchronous {
    private static final String WEBHOOK_ID_HEADER = "X-Nexus-Webhook-ID";
    private static final String WEBHOOK_DELIVERY_HEADER = "X-Nexus-Webhook-Delivery";
    @VisibleForTesting
    static final String WEBHOOK_SIGNATURE_HEADER = "X-Nexus-Webhook-Signature";
    private static final String HMAC_SHA1 = "HmacSHA1";
    private static final BaseEncoding HEX = BaseEncoding.base16().lowerCase();
    private final ObjectMapper objectMapper = new ObjectMapper().disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private final Provider<CloseableHttpClient> httpClientProvider;
    private final List<Webhook> webhooks;
    private final ThreadPoolExecutor threadPoolExecutor;

    @Inject
    public WebhookServiceImpl(Provider<CloseableHttpClient> httpClientProvider, List<Webhook> webhooks, @Named(value="${nexus.webhook.pool.size:-128}") @Named(value="${nexus.webhook.pool.size:-128}") int poolSize) {
        this.httpClientProvider = (Provider)Preconditions.checkNotNull(httpClientProvider);
        this.webhooks = (List)Preconditions.checkNotNull(webhooks);
        Preconditions.checkArgument((poolSize > 0 ? 1 : 0) != 0, (Object)"Pool size must be greater than zero");
        this.threadPoolExecutor = new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NexusThreadFactory("webhookService", "requestRool", 1), new ThreadPoolExecutor.AbortPolicy());
    }

    @Nullable
    private static String extractResponseBody(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            try {
                String body = EntityUtils.toString((HttpEntity)entity);
                if (body != null && body.length() != 0 && !body.contains("<html")) {
                    String string = body;
                    return string;
                }
            }
            finally {
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        return null;
    }

    private static String sign(String body, String secret) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec key = new SecretKeySpec(secret.getBytes(), HMAC_SHA1);
        Mac mac = Mac.getInstance(HMAC_SHA1);
        mac.init(key);
        byte[] bytes = mac.doFinal(body.getBytes());
        return HEX.encode(bytes);
    }

    public List<Webhook> getWebhooks() {
        return ImmutableList.copyOf(this.webhooks);
    }

    public void queue(WebhookRequest request) {
        Preconditions.checkNotNull((Object)request);
        this.threadPoolExecutor.execute(() -> {
            try {
                this.send(request);
            }
            catch (Exception e) {
                this.log.error("Failed to send webhook request:{}", (Object)request, (Object)e);
            }
        });
    }

    @Subscribe
    @AllowConcurrentEvents
    @InternalAccessible
    void on(WebhookRequestSendEvent event) {
        this.queue(event.getRequest());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void send(WebhookRequest request) throws Exception {
        Preconditions.checkNotNull((Object)request);
        this.log.debug("Sending webhook request: {}", (Object)request);
        Webhook webhook = request.getWebhook();
        String json = this.objectMapper.writeValueAsString((Object)request.getPayload());
        HttpPost httpPost = new HttpPost(request.getUrl());
        httpPost.setHeader(WEBHOOK_ID_HEADER, webhook.getId());
        httpPost.setHeader(WEBHOOK_DELIVERY_HEADER, request.getId());
        if (!StringUtils.isEmpty((CharSequence)request.getSecret())) {
            httpPost.setHeader(WEBHOOK_SIGNATURE_HEADER, WebhookServiceImpl.sign(json, request.getSecret()));
        }
        httpPost.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        this.log.debug("Sending POST request: {}", (Object)httpPost);
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            CloseableHttpClient httpClient = (CloseableHttpClient)this.httpClientProvider.get();
            try {
                try (CloseableHttpResponse putResponse = httpClient.execute((HttpUriRequest)httpPost);){
                    StatusLine status = putResponse.getStatusLine();
                    this.log.debug("Response status: {}", (Object)status);
                    int code = status.getStatusCode();
                    if (code >= 300) {
                        String message = WebhookServiceImpl.extractResponseBody((HttpResponse)putResponse);
                        if (message != null) throw new HttpResponseException(code, message);
                        message = status.getReasonPhrase();
                        throw new HttpResponseException(code, message);
                    }
                }
                if (httpClient == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (httpClient == null) throw throwable;
                httpClient.close();
                throw throwable;
            }
            httpClient.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @VisibleForTesting
    public boolean isCalmPeriod() {
        return this.threadPoolExecutor.getQueue().isEmpty() && this.threadPoolExecutor.getActiveCount() == 0;
    }

    @Gauge(name="nexus.webhooks.service.executor.queueSize")
    public int webhookQueueSize() {
        return this.threadPoolExecutor.getQueue().size();
    }
}

