/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.status;

import com.codahale.metrics.annotation.Timed;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.google.common.base.Preconditions;
import java.util.SortedMap;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FreezeService;
import org.sonatype.nexus.common.log.ExceptionSummarizer;
import org.sonatype.nexus.internal.status.StatusResourceDoc;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Path(value="/v1/status")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class StatusResource
extends ComponentSupport
implements Resource,
StatusResourceDoc {
    public static final String RESOURCE_URI = "/v1/status";
    private final FreezeService freezeService;
    private HealthCheckRegistry registry;
    private final ExceptionSummarizer exceptionSummarizer;

    @Inject
    public StatusResource(FreezeService freezeService, HealthCheckRegistry registry) {
        this.exceptionSummarizer = ExceptionSummarizer.summarize((BiPredicate)ExceptionSummarizer.sameType(), (BiConsumer)ExceptionSummarizer.warn((Logger)this.log));
        this.freezeService = (FreezeService)Preconditions.checkNotNull((Object)freezeService);
        this.registry = (HealthCheckRegistry)Preconditions.checkNotNull((Object)registry);
    }

    @Override
    @GET
    @Timed
    public Response isAvailable() {
        try {
            this.freezeService.checkReadable("Read check failed");
            return Response.ok().build();
        }
        catch (Exception e) {
            this.exceptionSummarizer.log("Status health check failed, responding server is unavailable", e);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
    }

    @Override
    @GET
    @Path(value="/writable")
    @Timed
    public Response isWritable() {
        try {
            if (this.freezeService.isFrozen()) {
                this.log.info("Status health check failed because database is frozen");
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
            this.freezeService.checkWritable("Write check failed");
            return Response.ok().build();
        }
        catch (Exception e) {
            this.exceptionSummarizer.log("Status health check failed, responding server is unavailable", e);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
    }

    @Override
    @GET
    @Path(value="/check")
    @Timed
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:metrics:read"})
    public SortedMap<String, HealthCheck.Result> getSystemStatusChecks() {
        return this.registry.runHealthChecks();
    }
}

