/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.status;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.app.ManagedLifecycleManager;
import org.sonatype.nexus.internal.status.HealthCheckComponentSupport;

@Named(value="Lifecycle Phase")
@Singleton
public class LifecyclePhaseHealthCheck
extends HealthCheckComponentSupport {
    private final ManagedLifecycle.Phase finalPhase;
    private final ManagedLifecycleManager lifecycleManager;

    @Inject
    public LifecyclePhaseHealthCheck(ManagedLifecycleManager lifecycleManager) {
        this.lifecycleManager = (ManagedLifecycleManager)Preconditions.checkNotNull((Object)lifecycleManager);
        this.finalPhase = ManagedLifecycle.Phase.values()[ManagedLifecycle.Phase.values().length - 1];
    }

    protected HealthCheck.Result check() {
        return this.finalPhase == this.lifecycleManager.getCurrentPhase() ? HealthCheck.Result.healthy() : HealthCheck.Result.unhealthy((String)this.unhealthyMsg());
    }

    private String unhealthyMsg() {
        return String.format("Nexus's current lifecycle phase is %s, but it should be %s", this.lifecycleManager.getCurrentPhase().name(), this.finalPhase.name());
    }
}

