/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.selector.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import java.util.List;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.datastore.api.DuplicateKeyException;
import org.sonatype.nexus.internal.selector.orient.OrientSelectorConfigurationEntityAdapter;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.selector.OrientSelectorConfiguration;
import org.sonatype.nexus.selector.SelectorConfiguration;
import org.sonatype.nexus.selector.SelectorConfigurationStore;

@Named(value="orient")
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientSelectorConfigurationStore
extends StateGuardLifecycleSupport
implements SelectorConfigurationStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final OrientSelectorConfigurationEntityAdapter entityAdapter;

    @Inject
    public OrientSelectorConfigurationStore(@Named(value="config") @Named(value="config") Provider<DatabaseInstance> databaseInstance, OrientSelectorConfigurationEntityAdapter entityAdapter) {
        this.databaseInstance = databaseInstance;
        this.entityAdapter = entityAdapter;
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Guarded(by={"STARTED"})
    public List<SelectorConfiguration> browse() {
        return (List)OrientTransactional.inTx(this.databaseInstance).call(db -> ImmutableList.copyOf((Iterable)this.entityAdapter.browse(db)));
    }

    @Guarded(by={"STARTED"})
    public SelectorConfiguration read(EntityId entityId) {
        Preconditions.checkNotNull((Object)entityId);
        return (SelectorConfiguration)OrientTransactional.inTx(this.databaseInstance).call(db -> (OrientSelectorConfiguration)this.entityAdapter.read(db, entityId));
    }

    @Guarded(by={"STARTED"})
    public SelectorConfiguration getByName(String name) {
        Preconditions.checkNotNull((Object)name);
        return (SelectorConfiguration)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.getByName(db, name));
    }

    @Guarded(by={"STARTED"})
    public void create(SelectorConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkArgument((boolean)(configuration instanceof OrientSelectorConfiguration), (Object)"Configuration is not an OrientSelectorConfiguration");
        try {
            OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
                ODocument oDocument = this.entityAdapter.addEntity(db, (Entity)((OrientSelectorConfiguration)configuration));
            });
        }
        catch (ORecordDuplicatedException e) {
            throw new DuplicateKeyException((Throwable)e);
        }
    }

    @Guarded(by={"STARTED"})
    public void update(SelectorConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkArgument((boolean)(configuration instanceof OrientSelectorConfiguration), (Object)"Configuration is not an OrientSelectorConfiguration");
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            ODocument oDocument = this.entityAdapter.editEntity(db, (Entity)((OrientSelectorConfiguration)configuration));
        });
    }

    @Guarded(by={"STARTED"})
    public void delete(SelectorConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkArgument((boolean)(configuration instanceof OrientSelectorConfiguration), (Object)"Configuration is not an OrientSelectorConfiguration");
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> this.entityAdapter.deleteEntity(db, (Entity)((OrientSelectorConfiguration)configuration)));
    }

    public SelectorConfiguration newSelectorConfiguration() {
        return this.entityAdapter.newEntity();
    }
}

