/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.selector.orient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.internal.selector.orient.OrientSelectorConfigurationCreatedEvent;
import org.sonatype.nexus.internal.selector.orient.OrientSelectorConfigurationDeletedEvent;
import org.sonatype.nexus.internal.selector.orient.OrientSelectorConfigurationUpdatedEvent;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.AttachedEntityMetadata;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.selector.OrientSelectorConfiguration;
import org.sonatype.nexus.selector.SelectorConfiguration;

@Named
@Singleton
public class OrientSelectorConfigurationEntityAdapter
extends IterableEntityAdapter<OrientSelectorConfiguration> {
    private static final String DB_CLASS = new OClassNameBuilder().prefix("selector").type("selector").build();
    private static final String P_NAME = "name";
    private static final String P_TYPE = "type";
    private static final String P_DESCRIPTION = "description";
    private static final String P_ATTRIBUTES = "attributes";
    private static final String FIND_BY_NAME = String.format("select from %s where %s = :%s", DB_CLASS, "name", "name");
    @VisibleForTesting
    static final String I_NAME = new OIndexNameBuilder().type(DB_CLASS).property("name").build();

    public OrientSelectorConfigurationEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_NAME, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_TYPE, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_DESCRIPTION, OType.STRING);
        type.createProperty(P_ATTRIBUTES, OType.EMBEDDEDMAP).setMandatory(true).setNotNull(true);
        type.createIndex(I_NAME, OClass.INDEX_TYPE.UNIQUE, new String[]{P_NAME});
    }

    @Nullable
    public SelectorConfiguration getByName(ODatabaseDocumentTx db, String name) {
        ImmutableMap parameters = ImmutableMap.of((Object)P_NAME, (Object)name);
        Iterable docs = (Iterable)db.command((OCommandRequest)new OCommandSQL(FIND_BY_NAME)).execute(new Object[]{parameters});
        if (!docs.iterator().hasNext()) {
            return null;
        }
        return (SelectorConfiguration)this.readEntity((OIdentifiable)Iterables.getFirst((Iterable)docs, null));
    }

    protected OrientSelectorConfiguration newEntity() {
        return new OrientSelectorConfiguration();
    }

    protected void readFields(ODocument document, OrientSelectorConfiguration entity) {
        String name = (String)document.field(P_NAME, OType.STRING);
        String type = (String)document.field(P_TYPE, OType.STRING);
        String description = (String)document.field(P_DESCRIPTION, OType.STRING);
        Map attributes = (Map)document.field(P_ATTRIBUTES, OType.EMBEDDEDMAP);
        entity.setName(name);
        entity.setType(type);
        entity.setDescription(description);
        entity.setAttributes(this.detachable(attributes));
    }

    protected void writeFields(ODocument document, OrientSelectorConfiguration entity) {
        document.field(P_NAME, (Object)entity.getName());
        document.field(P_TYPE, (Object)entity.getType());
        document.field(P_DESCRIPTION, (Object)entity.getDescription());
        document.field(P_ATTRIBUTES, (Object)entity.getAttributes());
    }

    public boolean sendEvents() {
        return true;
    }

    public EntityEvent newEvent(ODocument document, EntityAdapter.EventKind eventKind) {
        AttachedEntityMetadata metadata = new AttachedEntityMetadata((EntityAdapter)this, document);
        switch (eventKind) {
            case CREATE: {
                return new OrientSelectorConfigurationCreatedEvent((EntityMetadata)metadata);
            }
            case UPDATE: {
                return new OrientSelectorConfigurationUpdatedEvent((EntityMetadata)metadata);
            }
            case DELETE: {
                return new OrientSelectorConfigurationDeletedEvent((EntityMetadata)metadata);
            }
        }
        return null;
    }
}

