/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.selector;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.cache.Cache;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.subject.Subject;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.cache.CacheHelper;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.datastore.api.DuplicateKeyException;
import org.sonatype.nexus.distributed.event.service.api.common.RoleConfigurationEvent;
import org.sonatype.nexus.distributed.event.service.api.common.SelectorConfigurationChangedEvent;
import org.sonatype.nexus.internal.selector.SelectorConfigurationEvent;
import org.sonatype.nexus.repository.security.RepositorySelector;
import org.sonatype.nexus.rest.ValidationErrorsException;
import org.sonatype.nexus.security.SecuritySystem;
import org.sonatype.nexus.security.authz.AuthorizationManager;
import org.sonatype.nexus.security.authz.NoSuchAuthorizationManagerException;
import org.sonatype.nexus.security.privilege.Privilege;
import org.sonatype.nexus.security.role.Role;
import org.sonatype.nexus.security.role.RoleEvent;
import org.sonatype.nexus.security.role.RoleIdentifier;
import org.sonatype.nexus.security.user.User;
import org.sonatype.nexus.security.user.UserNotFoundException;
import org.sonatype.nexus.selector.CselToSql;
import org.sonatype.nexus.selector.Selector;
import org.sonatype.nexus.selector.SelectorConfiguration;
import org.sonatype.nexus.selector.SelectorConfigurationStore;
import org.sonatype.nexus.selector.SelectorEvaluationException;
import org.sonatype.nexus.selector.SelectorFactory;
import org.sonatype.nexus.selector.SelectorManager;
import org.sonatype.nexus.selector.SelectorSqlBuilder;
import org.sonatype.nexus.selector.VariableSource;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
public class SelectorManagerImpl
extends StateGuardLifecycleSupport
implements SelectorManager,
EventAware {
    private static final SoftReference<List<SelectorConfiguration>> EMPTY_CACHE = new SoftReference<Object>(null);
    private static final String USER_CACHE_KEY = "SelectorManager";
    private final SelectorConfigurationStore store;
    private final SecuritySystem securitySystem;
    private final LoadingCache<SelectorConfiguration, Selector> selectorCache;
    private final CacheHelper cacheHelper;
    private final Duration userCacheTimeout;
    private volatile SoftReference<List<SelectorConfiguration>> cachedBrowseResult = EMPTY_CACHE;
    private Map<String, Role> rolesCache = Collections.emptyMap();
    private Cache<String, User> userCache;

    @Inject
    public SelectorManagerImpl(SelectorConfigurationStore store, SecuritySystem securitySystem, SelectorFactory selectorFactory, CacheHelper cacheHelper, @Named(value="${nexus.shiro.cache.defaultTimeToLive:-2m}") @Named(value="${nexus.shiro.cache.defaultTimeToLive:-2m}") Time userCacheTimeout) {
        this.store = (SelectorConfigurationStore)Preconditions.checkNotNull((Object)store);
        this.securitySystem = (SecuritySystem)Preconditions.checkNotNull((Object)securitySystem);
        this.cacheHelper = cacheHelper;
        this.userCacheTimeout = new Duration(userCacheTimeout.getUnit(), userCacheTimeout.getValue());
        Preconditions.checkNotNull((Object)selectorFactory);
        this.selectorCache = CacheBuilder.newBuilder().softValues().build(CacheLoader.from(config -> {
            String type = config.getType();
            String expression = (String)config.getAttributes().get("expression");
            return selectorFactory.createSelector(type, expression);
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Guarded(by={"STARTED"})
    public List<SelectorConfiguration> browse() {
        ImmutableList result = this.cachedBrowseResult.get();
        if (result == null) {
            SelectorManagerImpl selectorManagerImpl = this;
            synchronized (selectorManagerImpl) {
                result = this.cachedBrowseResult.get();
                if (result == null) {
                    result = ImmutableList.copyOf((Collection)this.store.browse());
                    this.cachedBrowseResult = new SoftReference<ImmutableList>(result);
                }
            }
        }
        return result;
    }

    @Guarded(by={"STARTED"})
    public List<SelectorConfiguration> browse(String selectorType) {
        Preconditions.checkNotNull((Object)selectorType);
        return this.browse().stream().filter(config -> selectorType.equals(config.getType())).collect(Collectors.toList());
    }

    @Guarded(by={"STARTED"})
    public SelectorConfiguration read(EntityId entityId) {
        return this.store.read(entityId);
    }

    @Guarded(by={"STARTED"})
    public SelectorConfiguration readByName(String name) {
        return this.store.getByName(name);
    }

    @Guarded(by={"STARTED"})
    public Optional<SelectorConfiguration> findByName(String name) {
        return this.browse().stream().filter(selector -> StringUtils.equals((CharSequence)name, (CharSequence)selector.getName())).findFirst();
    }

    @Guarded(by={"STARTED"})
    public void create(SelectorConfiguration configuration) {
        this.store.create(configuration);
    }

    public void create(String name, String type, String description, Map<String, String> attributes) {
        SelectorConfiguration selectorConfiguration = this.store.newSelectorConfiguration();
        selectorConfiguration.setName(name);
        selectorConfiguration.setType(type);
        selectorConfiguration.setDescription(description);
        selectorConfiguration.setAttributes(attributes);
        try {
            this.store.create(selectorConfiguration);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            throw new ValidationErrorsException("name", "A selector with the same name already exists. Name must be unique.");
        }
    }

    @Guarded(by={"STARTED"})
    public void update(SelectorConfiguration configuration) {
        this.store.update(configuration);
    }

    @Guarded(by={"STARTED"})
    public void delete(SelectorConfiguration configuration) {
        if (this.isInUse(configuration)) {
            throw new IllegalStateException("Content selector " + configuration.getName() + " is in use and cannot be deleted");
        }
        this.store.delete(configuration);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(SelectorConfigurationEvent event) {
        this.cachedBrowseResult = EMPTY_CACHE;
        this.rolesCache = Collections.emptyMap();
        this.selectorCache.invalidateAll();
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RoleEvent event) {
        this.rolesCache = Collections.emptyMap();
    }

    @Subscribe
    public void on(SelectorConfigurationChangedEvent event) {
        this.log.debug("Selector configuration has {} on a remote node. Invalidate the cache.", (Object)event.getEventType());
        this.cachedBrowseResult = EMPTY_CACHE;
        this.rolesCache = Collections.emptyMap();
        this.selectorCache.invalidateAll();
    }

    @Subscribe
    public void on(RoleConfigurationEvent event) {
        this.rolesCache = Collections.emptyMap();
    }

    @Guarded(by={"STARTED"})
    public boolean evaluate(SelectorConfiguration selectorConfiguration, VariableSource variableSource) throws SelectorEvaluationException {
        try {
            return ((Selector)this.selectorCache.get((Object)selectorConfiguration)).evaluate(variableSource);
        }
        catch (Exception e) {
            throw new SelectorEvaluationException("Selector '" + selectorConfiguration.getName() + "' cannot be evaluated", e);
        }
    }

    public void toSql(SelectorConfiguration selectorConfiguration, SelectorSqlBuilder sqlBuilder) throws SelectorEvaluationException {
        try {
            ((Selector)this.selectorCache.get((Object)selectorConfiguration)).toSql(sqlBuilder);
        }
        catch (Exception e) {
            throw new SelectorEvaluationException("Selector '" + selectorConfiguration.getName() + "' cannot be represented as SQL", e);
        }
    }

    public <T> void toSql(SelectorConfiguration selectorConfiguration, T sqlBuilder, CselToSql<T> cselToSql) throws SelectorEvaluationException {
        try {
            ((Selector)this.selectorCache.get((Object)selectorConfiguration)).toSql(sqlBuilder, cselToSql);
        }
        catch (Exception e) {
            throw new SelectorEvaluationException("Selector '" + selectorConfiguration.getName() + "' cannot be represented as SQL", e);
        }
    }

    @Guarded(by={"STARTED"})
    public List<SelectorConfiguration> browseActive(Collection<String> repositoryNames, Collection<String> formats) {
        User currentUser;
        AuthorizationManager authorizationManager;
        try {
            authorizationManager = this.securitySystem.getAuthorizationManager("default");
            currentUser = this.getCurrentUser();
        }
        catch (NoSuchAuthorizationManagerException | UserNotFoundException e) {
            this.log.warn("Unable to load active content selectors", e);
            return Collections.emptyList();
        }
        if (currentUser == null) {
            return Collections.emptyList();
        }
        List<String> roleIds = currentUser.getRoles().stream().map(RoleIdentifier::getRoleId).collect(Collectors.toList());
        Set privilegeIds = this.getRoles(roleIds, authorizationManager).stream().map(Role::getPrivileges).flatMap(Collection::stream).collect(Collectors.toSet());
        List contentSelectorNames = authorizationManager.getPrivileges(privilegeIds).stream().filter(this.repositoryFormatOrNameMatcher(repositoryNames, formats)).map(this::getContentSelector).collect(Collectors.toList());
        return this.browse().stream().filter(selector -> contentSelectorNames.contains(selector.getName())).collect(Collectors.toList());
    }

    public SelectorConfiguration newSelectorConfiguration() {
        return this.store.newSelectorConfiguration();
    }

    public SelectorConfiguration newSelectorConfiguration(String name, String type, String description, Map<String, ?> attributes) {
        SelectorConfiguration selectorConfiguration = this.store.newSelectorConfiguration();
        selectorConfiguration.setName(name);
        selectorConfiguration.setType(type);
        selectorConfiguration.setDescription(description);
        selectorConfiguration.setAttributes(attributes);
        return selectorConfiguration;
    }

    private User getCurrentUser() throws UserNotFoundException {
        Subject subject = this.securitySystem.getSubject();
        if (subject.isAuthenticated()) {
            String userKey;
            Cache<String, User> cache = this.getUserCache();
            User currentUser = (User)cache.get((Object)(userKey = String.valueOf(subject.getPrincipal().toString()) + subject.getPrincipals().getRealmNames().toString()));
            if (currentUser == null && (currentUser = this.securitySystem.currentUser()) != null) {
                cache.put((Object)userKey, (Object)currentUser);
            }
            return currentUser;
        }
        return null;
    }

    private Cache<String, User> getUserCache() {
        if (this.userCache == null) {
            this.userCache = this.cacheHelper.maybeCreateCache(USER_CACHE_KEY, CreatedExpiryPolicy.factoryOf((Duration)this.userCacheTimeout));
        }
        return this.userCache;
    }

    private boolean matchesFormatOrRepository(Collection<String> repositoryNames, Collection<String> formats, Privilege privilege) {
        boolean isMatchingRepository;
        String type = privilege.getType();
        String selector = (String)privilege.getProperties().get("repository");
        if (selector == null) {
            return false;
        }
        RepositorySelector repositorySelector = RepositorySelector.fromSelector((String)selector);
        boolean isRepositoryContentSelector = "repository-content-selector".equals(type);
        boolean matchesFormat = formats.contains(repositorySelector.getFormat()) || repositorySelector.isAllFormats();
        boolean matchesRepositoryName = repositoryNames.contains(repositorySelector.getName());
        boolean isMatchingFormat = isRepositoryContentSelector && matchesFormat && repositorySelector.isAllRepositories();
        boolean bl = isMatchingRepository = isRepositoryContentSelector && matchesRepositoryName;
        return isMatchingFormat || isMatchingRepository;
    }

    private List<Role> getRoles(List<String> roleIds, AuthorizationManager authorizationManager) {
        try {
            Map<String, Object> roleMap;
            Map<String, Role> cacheSnapshot = this.rolesCache;
            if (cacheSnapshot.isEmpty()) {
                this.rolesCache = roleMap = this.securitySystem.listRoles("default").stream().collect(Collectors.toMap(Role::getRoleId, Function.identity()));
            } else {
                roleMap = cacheSnapshot;
            }
            HashSet results = new HashSet();
            roleIds.forEach(roleId -> this.traverseRoleTree((String)roleId, (Map<String, Role>)roleMap, results));
            return results.stream().map(roleMap::get).collect(Collectors.toList());
        }
        catch (NoSuchAuthorizationManagerException e) {
            this.log.error("Missing default user manager", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void traverseRoleTree(String roleId, Map<String, Role> roleMap, Set<String> results) {
        if (results.contains(roleId)) {
            return;
        }
        Role role = roleMap.get(roleId);
        if (role == null) {
            return;
        }
        results.add(roleId);
        role.getRoles().forEach(childId -> this.traverseRoleTree((String)childId, roleMap, results));
    }

    private Predicate<Privilege> repositoryFormatOrNameMatcher(Collection<String> repositoryNames, Collection<String> formats) {
        return p -> this.matchesFormatOrRepository(repositoryNames, formats, (Privilege)p);
    }

    private String getContentSelector(Privilege privilege) {
        return privilege.getPrivilegeProperty("contentSelector");
    }

    private boolean isInUse(SelectorConfiguration configuration) {
        return this.securitySystem.listPrivileges().stream().filter(privilege -> "repository-content-selector".equals(privilege.getType())).anyMatch(privilege -> privilege.getPrivilegeProperty("contentSelector").equals(configuration.getName()));
    }
}

