/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.selector;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.selector.SelectorConfiguration;
import org.sonatype.nexus.selector.SelectorEvaluationException;
import org.sonatype.nexus.selector.SelectorFilterBuilder;
import org.sonatype.nexus.selector.SelectorManager;
import org.sonatype.nexus.selector.SelectorSqlBuilder;

@Named
@Singleton
public class SelectorFilterBuilderImpl
extends ComponentSupport
implements SelectorFilterBuilder {
    public static String FILTER_PARAMS = "filterParams";
    private final SelectorManager selectorManager;

    @Inject
    public SelectorFilterBuilderImpl(SelectorManager selectorManager) {
        this.selectorManager = Objects.requireNonNull(selectorManager);
    }

    @Nullable
    public String buildFilter(String format, String pathAlias, List<SelectorConfiguration> selectors, Map<String, Object> filterParameters) {
        List<SelectorConfiguration> activeSelectors = selectors.stream().filter(s -> !"jexl".equals(s.getType())).collect(Collectors.toList());
        if (activeSelectors.isEmpty()) {
            return null;
        }
        StringBuilder filterBuilder = new StringBuilder();
        if (activeSelectors.size() > 1) {
            filterBuilder.append('(');
        }
        SelectorSqlBuilder sqlBuilder = new SelectorSqlBuilder().propertyAlias("path", pathAlias).propertyAlias("format", "'" + format + "'").parameterPrefix("#{" + FILTER_PARAMS + ".").parameterSuffix("}");
        this.appendSelectors(filterBuilder, sqlBuilder, activeSelectors, filterParameters);
        if (activeSelectors.size() > 1) {
            filterBuilder.append(')');
        }
        return filterBuilder.toString();
    }

    public void appendSelectors(StringBuilder filterBuilder, SelectorSqlBuilder sqlBuilder, List<SelectorConfiguration> selectors, Map<String, Object> filterParameters) {
        int selectorCount = 0;
        for (SelectorConfiguration selector : selectors) {
            try {
                try {
                    sqlBuilder.parameterNamePrefix("s" + selectorCount + "p");
                    this.selectorManager.toSql(selector, sqlBuilder);
                    if (selectorCount > 0) {
                        filterBuilder.append(" or ");
                    }
                    filterBuilder.append('(').append(sqlBuilder.getQueryString()).append(')');
                    filterParameters.putAll(sqlBuilder.getQueryParameters());
                    ++selectorCount;
                }
                catch (SelectorEvaluationException e) {
                    this.log.warn("Problem evaluating selector {} as SQL", (Object)selector.getName(), (Object)(this.log.isDebugEnabled() ? e : null));
                    sqlBuilder.clearQueryString();
                    continue;
                }
            }
            catch (Throwable throwable) {
                sqlBuilder.clearQueryString();
                throw throwable;
            }
            sqlBuilder.clearQueryString();
        }
    }
}

