/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.selector;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.internal.selector.SelectorConfigurationData;
import org.sonatype.nexus.selector.SelectorConfigurationStore;
import org.sonatype.nexus.supportzip.ExportConfigData;
import org.sonatype.nexus.supportzip.ImportData;
import org.sonatype.nexus.supportzip.datastore.JsonExporter;

@Named(value="selectorConfigurationExport")
@Singleton
public class SelectorConfigurationExport
extends JsonExporter
implements ExportConfigData,
ImportData {
    private final SelectorConfigurationStore store;

    @Inject
    public SelectorConfigurationExport(SelectorConfigurationStore store) {
        this.store = store;
    }

    public void export(File file) throws IOException {
        this.log.debug("Export SelectorConfiguration data to {}", (Object)file);
        List configurations = this.store.browse();
        this.exportToJson(configurations, file);
    }

    public void restore(File file) throws IOException {
        this.log.debug("Restoring SelectorConfiguration data from {}", (Object)file);
        this.importFromJson(file, SelectorConfigurationData.class).forEach(arg_0 -> ((SelectorConfigurationStore)this.store).create(arg_0));
    }
}

