/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.selector;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.internal.status.HealthCheckComponentSupport;
import org.sonatype.nexus.selector.SelectorConfiguration;
import org.sonatype.nexus.selector.SelectorManager;

@Named(value="Coordinate Content Selectors")
@Singleton
public class CoordinateContentSelectorHealthCheck
extends HealthCheckComponentSupport {
    private static final String SELECTORS = "selectors";
    private static final String SELECTOR = "selector";
    private static final String HEALTHY_MESSAGE = "No content selectors using coordinates found.";
    private static final String UNHEALTHY_MESSAGE = "Found %d content %s with coordinates, these will be deprecated soon: %s";
    private final SelectorManager selectorManager;

    @Inject
    public CoordinateContentSelectorHealthCheck(SelectorManager selectorManager) {
        this.selectorManager = (SelectorManager)Preconditions.checkNotNull((Object)selectorManager);
    }

    protected HealthCheck.Result check() {
        List coordinateSelectors = this.selectorManager.browse().stream().filter(SelectorConfiguration::hasCoordinates).collect(Collectors.toList());
        if (coordinateSelectors.isEmpty()) {
            return HealthCheck.Result.healthy((String)HEALTHY_MESSAGE);
        }
        String coordinateSelectorNames = coordinateSelectors.stream().map(SelectorConfiguration::getName).sorted().collect(Collectors.joining(", "));
        return HealthCheck.Result.unhealthy((String)UNHEALTHY_MESSAGE, (Object[])new Object[]{coordinateSelectors.size(), coordinateSelectors.size() > 1 ? SELECTORS : SELECTOR, StringUtils.truncate((String)coordinateSelectorNames, (int)144)});
    }
}

