/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.apikey.upgrade;

import java.sql.Connection;
import java.util.Optional;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationStep;

@Named
public class ApiKeyUpgrade_1_31
extends ComponentSupport
implements DatabaseMigrationStep {
    private static final String DROP_CONSTRAINT = "ALTER TABLE api_key DROP CONSTRAINT pk_api_key_primaryprincipal_domain;";
    private static final String ADD_CONSTRAINT = "ALTER TABLE api_key ADD CONSTRAINT pk_api_key_primaryprincipal_domain_principals PRIMARY KEY (primary_principal, domain, principals);";

    public Optional<String> version() {
        return Optional.of("1.31");
    }

    public void migrate(Connection connection) throws Exception {
        boolean tableExists = this.tableExists(connection, "api_key");
        boolean indexExists = this.indexExists(connection, "pk_api_key_primaryprincipal_domain");
        this.log.info("Updating primary key for api_key. table_exists:{} index:{} change_required:{}", new Object[]{tableExists, indexExists, tableExists && indexExists});
        if (tableExists && indexExists) {
            this.runStatement(connection, "ALTER TABLE api_key DROP CONSTRAINT pk_api_key_primaryprincipal_domain;ALTER TABLE api_key ADD CONSTRAINT pk_api_key_primaryprincipal_domain_principals PRIMARY KEY (primary_principal, domain, principals);");
        }
    }
}

