/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.apikey.orient.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;

@Named
@Singleton
@Upgrades(model="api_key", from="1.0", to="1.1")
@DependsOn(model="security", version="1.3", checkpoint=true)
public class ApiKeyUpgrade_1_1
extends DatabaseUpgradeSupport {
    private static final String DB_API_KEY_CLASS = new OClassNameBuilder().type("api_key").build();
    private static final String P_DOMAIN = "domain";
    private static final String P_PRIMARY_PRINCIPAL = "primary_principal";
    private static final String P_PRINCIPALS = "principals";
    private static final String API_KEY_NEW_INDEX = new OIndexNameBuilder().type(DB_API_KEY_CLASS).property("domain").property("primary_principal").property("principals").build();
    private static final String DROP_INDEX = String.format("DROP INDEX %s", new OIndexNameBuilder().type(DB_API_KEY_CLASS).property("domain").property("primary_principal").build());
    private final Provider<DatabaseInstance> securityDatabaseInstance;

    @Inject
    public ApiKeyUpgrade_1_1(@Named(value="security") @Named(value="security") Provider<DatabaseInstance> securityDatabaseInstance) {
        this.securityDatabaseInstance = (Provider)Preconditions.checkNotNull(securityDatabaseInstance);
    }

    public void apply() throws Exception {
        if (ApiKeyUpgrade_1_1.hasSchemaClass(this.securityDatabaseInstance, (String)DB_API_KEY_CLASS)) {
            this.log.info("Updating {} index", (Object)DB_API_KEY_CLASS);
            ApiKeyUpgrade_1_1.withDatabaseAndClass(this.securityDatabaseInstance, (String)DB_API_KEY_CLASS, (db, type) -> {
                this.log.debug("Removing existing index");
                db.command((OCommandRequest)new OCommandSQL(DROP_INDEX)).execute(new Object[0]);
                this.log.debug("Create index");
                type.createIndex(API_KEY_NEW_INDEX, OClass.INDEX_TYPE.UNIQUE, new String[]{P_DOMAIN, P_PRIMARY_PRINCIPAL, P_PRINCIPALS});
            });
        }
    }
}

