/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.apikey.orient;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.internal.security.apikey.DefaultApiKeyFactory;
import org.sonatype.nexus.internal.security.apikey.orient.OrientApiKey;
import org.sonatype.nexus.internal.security.apikey.orient.OrientApiKeyEntityAdapter;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientOperations;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.security.UserPrincipalsExpired;
import org.sonatype.nexus.security.UserPrincipalsHelper;
import org.sonatype.nexus.security.authc.apikey.ApiKey;
import org.sonatype.nexus.security.authc.apikey.ApiKeyFactory;
import org.sonatype.nexus.security.authc.apikey.ApiKeyStore;
import org.sonatype.nexus.security.user.UserNotFoundException;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named(value="orient")
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientApiKeyStore
extends StateGuardLifecycleSupport
implements ApiKeyStore,
EventAware {
    private final Provider<DatabaseInstance> databaseInstance;
    private final OrientApiKeyEntityAdapter entityAdapter;
    private final UserPrincipalsHelper principalsHelper;
    private final Map<String, ApiKeyFactory> apiKeyFactories;
    private final DefaultApiKeyFactory defaultApiKeyFactory;

    @Inject
    public OrientApiKeyStore(@Named(value="security") @Named(value="security") Provider<DatabaseInstance> databaseInstance, OrientApiKeyEntityAdapter entityAdapter, UserPrincipalsHelper principalsHelper, Map<String, ApiKeyFactory> apiKeyFactories, DefaultApiKeyFactory defaultApiKeyFactory) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (OrientApiKeyEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
        this.principalsHelper = (UserPrincipalsHelper)Preconditions.checkNotNull((Object)principalsHelper);
        this.apiKeyFactories = (Map)Preconditions.checkNotNull(apiKeyFactories);
        this.defaultApiKeyFactory = (DefaultApiKeyFactory)((Object)Preconditions.checkNotNull((Object)((Object)defaultApiKeyFactory)));
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public ApiKey newApiKey(String domain, PrincipalCollection principals, char[] apiKey, OffsetDateTime created) {
        return new OrientApiKey(domain, principals, apiKey, created);
    }

    @Guarded(by={"STARTED"})
    public char[] createApiKey(String domain, PrincipalCollection principals) {
        Preconditions.checkNotNull((Object)domain);
        Preconditions.checkNotNull((Object)principals);
        try {
            char[] apiKeyCharArray = this.makeApiKey(domain, principals);
            this.persistApiKey(domain, principals, apiKeyCharArray);
            return apiKeyCharArray;
        }
        catch (ORecordDuplicatedException oRecordDuplicatedException) {
            return this.getApiKey(domain, principals).map(ApiKey::getApiKey).orElse(null);
        }
    }

    @Guarded(by={"STARTED"})
    public void persistApiKey(String domain, PrincipalCollection principals, char[] apiKey, OffsetDateTime date) {
        Preconditions.checkNotNull((Object)domain);
        Preconditions.checkNotNull((Object)principals);
        Preconditions.checkNotNull((Object)apiKey);
        OrientApiKey entity = this.entityAdapter.newEntity();
        entity.setDomain(domain);
        entity.setApiKey(apiKey);
        entity.setPrincipals(principals);
        entity.setCreated(date);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            ODocument oDocument = this.entityAdapter.addEntity(db, (Entity)entity);
        });
    }

    @Guarded(by={"STARTED"})
    public Optional<ApiKey> getApiKey(String domain, PrincipalCollection principals) {
        return (Optional)OrientTransactional.inTx(this.databaseInstance).call(db -> {
            for (OrientApiKey entity : this.findByPrimaryPrincipal(db, principals)) {
                if (!entity.getDomain().equals(domain) || !this.principalsEqual(entity.getPrincipals(), principals)) continue;
                return Optional.of(entity);
            }
            return Optional.empty();
        });
    }

    @Guarded(by={"STARTED"})
    public Optional<ApiKey> getApiKeyByToken(String domain, char[] apiKey) {
        return (Optional)OrientTransactional.inTx(this.databaseInstance).call(db -> Optional.ofNullable(this.entityAdapter.findByApiKey(db, domain, (char[])Preconditions.checkNotNull((Object)apiKey))));
    }

    @Guarded(by={"STARTED"})
    public void deleteApiKey(String domain, PrincipalCollection principals) {
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            for (OrientApiKey entity : this.findByPrimaryPrincipal(db, principals)) {
                if (!entity.getDomain().equals(domain) || !this.principalsEqual(entity.getPrincipals(), principals)) continue;
                this.entityAdapter.deleteEntity(db, (Entity)entity);
            }
        });
    }

    @Guarded(by={"STARTED"})
    public void deleteApiKeys(PrincipalCollection principals) {
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            for (OrientApiKey entity : this.findByPrimaryPrincipal(db, principals)) {
                if (!this.principalsEqual(entity.getPrincipals(), principals)) continue;
                this.entityAdapter.deleteEntity(db, (Entity)entity);
            }
        });
    }

    @Guarded(by={"STARTED"})
    public void deleteApiKeys() {
        OrientTransactional.inTxRetry(this.databaseInstance).run(this.entityAdapter::deleteAll);
    }

    @Guarded(by={"STARTED"})
    public void purgeApiKeys() {
        CancelableHelper.checkCancellation();
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            ArrayList<OrientApiKey> delete = new ArrayList<OrientApiKey>();
            for (OrientApiKey entity : this.entityAdapter.browse(db)) {
                CancelableHelper.checkCancellation();
                UnitOfWork work = UnitOfWork.pause();
                try {
                    try {
                        this.principalsHelper.getUserStatus(entity.getPrincipals());
                    }
                    catch (UserNotFoundException e) {
                        this.log.debug("Stale user found", (Throwable)e);
                        delete.add(entity);
                        UnitOfWork.resume((UnitOfWork)work);
                        db.activateOnCurrentThread();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    UnitOfWork.resume((UnitOfWork)work);
                    db.activateOnCurrentThread();
                    throw throwable;
                }
                UnitOfWork.resume((UnitOfWork)work);
                db.activateOnCurrentThread();
            }
            for (OrientApiKey entity : delete) {
                CancelableHelper.checkCancellation();
                this.entityAdapter.deleteEntity(db, (Entity)entity);
            }
        });
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(UserPrincipalsExpired event) {
        String userId = event.getUserId();
        if (userId != null) {
            this.deleteApiKeys((PrincipalCollection)new SimplePrincipalCollection((Object)userId, event.getSource()));
        } else {
            this.purgeApiKeys();
        }
    }

    private Iterable<OrientApiKey> findByPrimaryPrincipal(ODatabaseDocumentTx db, PrincipalCollection principals) {
        String primaryPrincipal = ((PrincipalCollection)Preconditions.checkNotNull((Object)principals)).getPrimaryPrincipal().toString();
        return this.entityAdapter.browseByPrimaryPrincipal(db, primaryPrincipal);
    }

    private char[] makeApiKey(String domain, PrincipalCollection principals) {
        ApiKeyFactory factory = this.apiKeyFactories.get(domain);
        if (factory != null) {
            return (char[])Preconditions.checkNotNull((Object)factory.makeApiKey(principals));
        }
        return this.defaultApiKeyFactory.makeApiKey(principals);
    }

    public Collection<ApiKey> browse(String domain) {
        Iterable keys = (Iterable)((OrientOperations)OrientTransactional.inTx(this.databaseInstance).retryOn(new Class[]{ONeedRetryException.class, ORecordNotFoundException.class})).call(db -> this.entityAdapter.browseByDomain(db, domain));
        return OrientApiKeyStore.convert(keys);
    }

    public Collection<ApiKey> browseByCreatedDate(String domain, OffsetDateTime created) {
        Iterable keys = (Iterable)((OrientOperations)OrientTransactional.inTx(this.databaseInstance).retryOn(new Class[]{ONeedRetryException.class, ORecordNotFoundException.class})).call(db -> this.entityAdapter.browseByDomainAndCreated(db, domain, created));
        return OrientApiKeyStore.convert(keys);
    }

    public int count(String domain) {
        return (Integer)((OrientOperations)OrientTransactional.inTx(this.databaseInstance).retryOn(new Class[]{ONeedRetryException.class})).call(db -> this.entityAdapter.countByDomainI(db, domain));
    }

    public void deleteApiKeys(String domain) {
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            for (OrientApiKey entity : this.entityAdapter.browseByDomain(db, domain)) {
                CancelableHelper.checkCancellation();
                this.entityAdapter.deleteEntity(db, (Entity)entity);
            }
        });
    }

    public void deleteApiKeys(OffsetDateTime expiration) {
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            for (OrientApiKey entity : this.entityAdapter.browseByExpiration(db, expiration)) {
                CancelableHelper.checkCancellation();
                this.entityAdapter.deleteEntity(db, (Entity)entity);
            }
        });
    }

    public void updateApiKey(ApiKey from, ApiKey to) {
        OrientApiKey fromApiKey = (OrientApiKey)from;
        fromApiKey.setApiKey(to.getApiKey());
        fromApiKey.setPrincipals(to.getPrincipals());
        fromApiKey.setCreated(to.getCreated());
        OrientTransactional.inTx(this.databaseInstance).run(db -> {
            ODocument oDocument = this.entityAdapter.editEntity(db, (Entity)fromApiKey);
        });
    }

    public Collection<ApiKey> browsePaginated(String domain, int page, int pageSize) {
        Iterable keys = (Iterable)((OrientOperations)OrientTransactional.inTx(this.databaseInstance).retryOn(new Class[]{ONeedRetryException.class, ORecordNotFoundException.class})).call(db -> this.entityAdapter.browseByDomainPaginated(db, domain, (page - 1) * pageSize, pageSize));
        return OrientApiKeyStore.convert(keys);
    }

    private static Collection<ApiKey> convert(Iterable<OrientApiKey> keys) {
        return StreamSupport.stream(keys.spliterator(), false).map(ApiKey.class::cast).collect(Collectors.toList());
    }

    private boolean principalsEqual(PrincipalCollection a, PrincipalCollection b) {
        return Objects.equals(a.getPrimaryPrincipal(), b.getPrimaryPrincipal()) && Objects.equals(a.getRealmNames(), b.getRealmNames());
    }
}

