/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.apikey.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.subject.PrincipalCollection;
import org.sonatype.nexus.common.io.ObjectInputStreamWithClassLoader;
import org.sonatype.nexus.internal.security.apikey.orient.OrientApiKey;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.orient.entity.action.DeleteEntitiesAction;
import org.sonatype.nexus.orient.entity.action.ReadEntityByPropertyAction;

@Named
@Singleton
public class OrientApiKeyEntityAdapter
extends IterableEntityAdapter<OrientApiKey> {
    private static final String DB_CLASS = new OClassNameBuilder().type("api_key").build();
    private static final String P_DOMAIN = "domain";
    private static final String P_APIKEY = "api_key";
    private static final String P_PRIMARY_PRINCIPAL = "primary_principal";
    private static final String P_PRINCIPALS = "principals";
    private static final String P_CREATED = "created";
    private static final String P_EXPIRED_TIME = "expired";
    private static final String I_APIKEY = new OIndexNameBuilder().type(DB_CLASS).property("domain").property("api_key").build();
    private static final String I_PRIMARY_PRINCIPAL = new OIndexNameBuilder().type(DB_CLASS).property("domain").property("primary_principal").property("principals").build();
    private static final String DOMAIN_QUERY_STRING = String.format("SELECT FROM %s WHERE %s = :domain ORDER BY %s", DB_CLASS, "domain", "created");
    private static final String DOMAIN_PAGINATED_QUERY_STRING = String.format("SELECT FROM %s WHERE %s = :domain ORDER BY %s SKIP :skip LIMIT :limit", DB_CLASS, "domain", "created");
    private static final String PRINCIPAL_QUERY_STRING = String.format("SELECT FROM %s WHERE %s = :primary_principal ORDER BY %s", DB_CLASS, "primary_principal", "created");
    private static final String DOMAIN_AND_CREATED_QUERY_STRING = String.format("SELECT FROM %s WHERE %s = :domain AND %s > :created ORDER BY %s", DB_CLASS, "domain", "created", "created");
    private static final String COUNT_DOMAIN_QUERY_STRING = String.format("SELECT count(*) as count FROM %s WHERE %s = :domain", DB_CLASS, "domain");
    private static final String EXPIRED_QUERY_STRING = String.format("SELECT FROM %s WHERE %s < :expired", DB_CLASS, "created");
    private final DeleteEntitiesAction deleteAll = new DeleteEntitiesAction((EntityAdapter)this);
    private final ReadEntityByPropertyAction<OrientApiKey> findByApiKey = new ReadEntityByPropertyAction((EntityAdapter)this, new String[]{"domain", "api_key"});
    private final ClassLoader uberClassLoader;

    @Inject
    public OrientApiKeyEntityAdapter(@Named(value="nexus-uber") @Named(value="nexus-uber") ClassLoader uberClassLoader) {
        super(DB_CLASS);
        this.uberClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)uberClassLoader);
    }

    protected void defineType(ODatabaseDocumentTx db, OClass type) {
        super.defineType(db, type);
        this.enableRecordEncryption(db, type);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_APIKEY, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_DOMAIN, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_PRIMARY_PRINCIPAL, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_PRINCIPALS, OType.BINARY).setMandatory(true).setNotNull(true);
        type.createProperty(P_CREATED, OType.LONG).setMandatory(true).setNotNull(true);
        type.createIndex(I_APIKEY, OClass.INDEX_TYPE.UNIQUE, new String[]{P_DOMAIN, P_APIKEY});
        type.createIndex(I_PRIMARY_PRINCIPAL, OClass.INDEX_TYPE.UNIQUE, new String[]{P_DOMAIN, P_PRIMARY_PRINCIPAL, P_PRINCIPALS});
    }

    protected OrientApiKey newEntity() {
        return new OrientApiKey();
    }

    protected void readFields(ODocument document, OrientApiKey entity) {
        String domain = (String)document.field(P_DOMAIN, OType.STRING);
        String apiKey = (String)document.field(P_APIKEY, OType.STRING);
        Long createdTimestamp = (Long)document.field(P_CREATED, OType.LONG);
        PrincipalCollection principals = (PrincipalCollection)this.deserialize(document, P_PRINCIPALS);
        entity.setDomain(domain);
        entity.setApiKey(apiKey.toCharArray());
        entity.setPrincipals(principals);
        if (createdTimestamp == null) {
            createdTimestamp = 0L;
        }
        OffsetDateTime created = OffsetDateTime.ofInstant(Instant.ofEpochMilli(createdTimestamp), ZoneOffset.UTC);
        entity.setCreated(created);
    }

    private Object deserialize(ODocument document, String fieldName) {
        byte[] bytes = (byte[])document.field(fieldName, OType.BINARY);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ObjectInputStreamWithClassLoader objects = new ObjectInputStreamWithClassLoader((InputStream)new ByteArrayInputStream(bytes), this.uberClassLoader);){
                return objects.readObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeFields(ODocument document, OrientApiKey entity) {
        document.field(P_DOMAIN, (Object)entity.getDomain());
        document.field(P_APIKEY, (Object)String.valueOf(entity.getApiKey()));
        document.field(P_PRIMARY_PRINCIPAL, (Object)entity.getPrincipals().getPrimaryPrincipal().toString());
        document.field(P_PRINCIPALS, (Object)this.serialize(entity.getPrincipals()));
        document.field(P_CREATED, (Object)Optional.ofNullable(entity.getCreated()).orElseGet(OffsetDateTime::now).toInstant().toEpochMilli());
    }

    private byte[] serialize(Object object) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayOutputStream bytes = new ByteArrayOutputStream();){
                ObjectOutputStream objects = new ObjectOutputStream(bytes);
                objects.writeObject(object);
                objects.flush();
                return bytes.toByteArray();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteAll(ODatabaseDocumentTx db) {
        this.deleteAll.execute(db);
    }

    public Iterable<OrientApiKey> browseByPrimaryPrincipal(ODatabaseDocumentTx db, String username) {
        ImmutableMap params = ImmutableMap.of((Object)P_PRIMARY_PRINCIPAL, (Object)username);
        return this.query(db, PRINCIPAL_QUERY_STRING, (Map<String, Object>)params);
    }

    public Iterable<OrientApiKey> browseByDomain(ODatabaseDocumentTx db, String domain) {
        ImmutableMap params = ImmutableMap.of((Object)P_DOMAIN, (Object)domain);
        return this.query(db, DOMAIN_QUERY_STRING, (Map<String, Object>)params);
    }

    public Iterable<OrientApiKey> browseByDomainPaginated(ODatabaseDocumentTx db, String domain, int skip, int limit) {
        ImmutableMap params = ImmutableMap.of((Object)P_DOMAIN, (Object)domain, (Object)"skip", (Object)skip, (Object)"limit", (Object)limit);
        return this.query(db, DOMAIN_PAGINATED_QUERY_STRING, (Map<String, Object>)params);
    }

    public int countByDomainI(ODatabaseDocumentTx db, String domain) {
        ImmutableMap params = ImmutableMap.of((Object)P_DOMAIN, (Object)domain);
        List results = (List)db.command((OCommandRequest)new OCommandSQL(COUNT_DOMAIN_QUERY_STRING)).execute(new Object[]{params});
        return (Integer)((ODocument)results.get(0)).field("count", Integer.class);
    }

    public Iterable<OrientApiKey> browseByDomainAndCreated(ODatabaseDocumentTx db, String domain, OffsetDateTime created) {
        ImmutableMap params = ImmutableMap.of((Object)P_DOMAIN, (Object)domain, (Object)P_CREATED, (Object)created.toInstant().toEpochMilli());
        return this.query(db, DOMAIN_AND_CREATED_QUERY_STRING, (Map<String, Object>)params);
    }

    private Iterable<OrientApiKey> query(ODatabaseDocumentTx db, String query, Map<String, Object> params) {
        List result = (List)db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(new Object[]{params});
        if (result != null) {
            return result.stream().map(arg_0 -> ((OrientApiKeyEntityAdapter)this).readEntity(arg_0)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Nullable
    public OrientApiKey findByApiKey(ODatabaseDocumentTx db, String domain, char[] apiKey) {
        Preconditions.checkNotNull((Object)domain);
        Preconditions.checkNotNull((Object)apiKey);
        return (OrientApiKey)this.findByApiKey.execute(db, new Object[]{domain, String.valueOf(apiKey)});
    }

    public Iterable<OrientApiKey> browseByExpiration(ODatabaseDocumentTx db, OffsetDateTime expiration) {
        ImmutableMap params = ImmutableMap.of((Object)P_EXPIRED_TIME, (Object)expiration.toInstant().toEpochMilli());
        return this.query(db, EXPIRED_QUERY_STRING, (Map<String, Object>)params);
    }
}

