/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.apikey.orient;

import com.google.common.base.Preconditions;
import java.time.OffsetDateTime;
import java.util.Arrays;
import org.apache.shiro.subject.PrincipalCollection;
import org.sonatype.nexus.common.entity.AbstractEntity;
import org.sonatype.nexus.security.authc.apikey.ApiKey;

public class OrientApiKey
extends AbstractEntity
implements ApiKey {
    private String domain;
    private PrincipalCollection principals;
    private char[] apiKey;
    private OffsetDateTime created;

    OrientApiKey() {
    }

    OrientApiKey(String domain, PrincipalCollection principals, char[] apiKey, OffsetDateTime created) {
        this.domain = (String)Preconditions.checkNotNull((Object)domain);
        this.principals = (PrincipalCollection)Preconditions.checkNotNull((Object)principals);
        this.apiKey = (char[])Preconditions.checkNotNull((Object)apiKey);
        this.created = created;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setPrincipals(PrincipalCollection principals) {
        this.principals = principals;
    }

    public void setApiKey(char[] apiKey) {
        this.apiKey = Arrays.copyOf(apiKey, apiKey.length);
    }

    public String getDomain() {
        return this.domain;
    }

    public PrincipalCollection getPrincipals() {
        return this.principals;
    }

    public char[] getApiKey() {
        return Arrays.copyOf(this.apiKey, this.apiKey.length);
    }

    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }
}

