/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.apikey;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.Base64Variants;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.ibatis.type.JdbcType;
import org.sonatype.nexus.datastore.mybatis.CipherAwareTypeHandler;
import org.sonatype.nexus.internal.security.apikey.ApiKeyToken;

@Named
@Singleton
public class ApiKeyTokenTypeHandler
extends CipherAwareTypeHandler<ApiKeyToken> {
    private static final Base64Variant BASE_64 = Base64Variants.getDefaultVariant();

    public final void setNonNullParameter(PreparedStatement ps, int parameterIndex, ApiKeyToken parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(parameterIndex, this.encrypt(parameter));
    }

    public final ApiKeyToken getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.decrypt(rs.getString(columnName));
    }

    public final ApiKeyToken getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.decrypt(rs.getString(columnIndex));
    }

    public final ApiKeyToken getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.decrypt(cs.getString(columnIndex));
    }

    private String encrypt(ApiKeyToken token) {
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(token.getCharBuffer());
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytes);
        return BASE_64.encode(this.cipher().encrypt(bytes));
    }

    private ApiKeyToken decrypt(String value) {
        if (value == null) {
            return null;
        }
        byte[] bytes = this.cipher().decrypt(BASE_64.decode(value));
        CharBuffer charBuffer = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(bytes));
        char[] chars = new char[charBuffer.remaining()];
        charBuffer.get(chars);
        return new ApiKeyToken(chars);
    }
}

