/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.apikey;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.internal.security.apikey.ApiKeyDAO;
import org.sonatype.nexus.internal.security.apikey.ApiKeyData;
import org.sonatype.nexus.internal.security.apikey.ApiKeyToken;
import org.sonatype.nexus.internal.security.apikey.DefaultApiKeyFactory;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.security.UserPrincipalsExpired;
import org.sonatype.nexus.security.UserPrincipalsHelper;
import org.sonatype.nexus.security.authc.apikey.ApiKey;
import org.sonatype.nexus.security.authc.apikey.ApiKeyFactory;
import org.sonatype.nexus.security.authc.apikey.ApiKeyStore;
import org.sonatype.nexus.security.user.UserNotFoundException;
import org.sonatype.nexus.transaction.Transactional;

@FeatureFlag(name="nexus.datastore.enabled")
@Named(value="mybatis")
@Singleton
public class ApiKeyStoreImpl
extends ConfigStoreSupport<ApiKeyDAO>
implements ApiKeyStore,
EventAware {
    private final UserPrincipalsHelper principalsHelper;
    private final Map<String, ApiKeyFactory> apiKeyFactories;
    private final DefaultApiKeyFactory defaultApiKeyFactory;

    @Inject
    public ApiKeyStoreImpl(DataSessionSupplier sessionSupplier, UserPrincipalsHelper principalsHelper, Map<String, ApiKeyFactory> apiKeyFactories, DefaultApiKeyFactory defaultApiKeyFactory) {
        super(sessionSupplier);
        this.principalsHelper = (UserPrincipalsHelper)Preconditions.checkNotNull((Object)principalsHelper);
        this.apiKeyFactories = (Map)Preconditions.checkNotNull(apiKeyFactories);
        this.defaultApiKeyFactory = (DefaultApiKeyFactory)((Object)Preconditions.checkNotNull((Object)((Object)defaultApiKeyFactory)));
    }

    public ApiKey newApiKey(String domain, PrincipalCollection principals, char[] apiKey, OffsetDateTime created) {
        return new ApiKeyData(domain, principals, new ApiKeyToken(apiKey), created);
    }

    public char[] createApiKey(String domain, PrincipalCollection principals) {
        char[] apiKey = this.makeApiKey(domain, principals);
        this.persistApiKey(domain, principals, apiKey);
        return apiKey;
    }

    private char[] makeApiKey(String domain, PrincipalCollection principals) {
        ApiKeyFactory factory = this.apiKeyFactories.get(domain);
        if (factory != null) {
            return (char[])Preconditions.checkNotNull((Object)factory.makeApiKey(principals));
        }
        return this.defaultApiKeyFactory.makeApiKey(principals);
    }

    @Transactional
    public void persistApiKey(String domain, PrincipalCollection principals, char[] apiKey, OffsetDateTime created) {
        ApiKeyData apiKeyData = new ApiKeyData();
        apiKeyData.setDomain(domain);
        apiKeyData.setPrincipals(principals);
        apiKeyData.setApiKey(apiKey);
        apiKeyData.setCreated(created);
        ((ApiKeyDAO)this.dao()).save(apiKeyData);
    }

    @Transactional
    public Optional<ApiKey> getApiKey(String domain, PrincipalCollection principals) {
        return this.findApiKey(domain, principals);
    }

    @Transactional
    public Optional<ApiKey> getApiKeyByToken(String domain, char[] apiKey) {
        return ((ApiKeyDAO)this.dao()).findPrincipals(domain, new ApiKeyToken(apiKey));
    }

    @Transactional
    public void deleteApiKey(String domain, PrincipalCollection principals) {
        this.findApiKey(domain, principals).map(ApiKey::getApiKey).map(ApiKeyToken::new).ifPresent(token -> {
            boolean bl = ((ApiKeyDAO)this.dao()).deleteKey(domain, (ApiKeyToken)token);
        });
    }

    @Transactional
    public void deleteApiKeys(PrincipalCollection principals) {
        ((ApiKeyDAO)this.dao()).findApiKeysForPrimary(principals.getPrimaryPrincipal().toString()).stream().filter(this.principalMatches(principals)).forEach(key -> {
            boolean bl = ((ApiKeyDAO)this.dao()).deleteKey(key.getDomain(), new ApiKeyToken(key.getApiKey()));
        });
    }

    @Transactional
    public void deleteApiKeys() {
        ((ApiKeyDAO)this.dao()).deleteAllKeys();
    }

    public void purgeApiKeys() {
        CancelableHelper.checkCancellation();
        ArrayList candidates = Lists.newArrayList(this.doBrowsePrincipals());
        Iterator itr = candidates.iterator();
        while (itr.hasNext()) {
            CancelableHelper.checkCancellation();
            if (!this.userExists((PrincipalCollection)itr.next())) continue;
            itr.remove();
        }
        for (PrincipalCollection principals : candidates) {
            CancelableHelper.checkCancellation();
            this.deleteApiKeys(principals);
        }
    }

    @Transactional
    protected Iterable<PrincipalCollection> doBrowsePrincipals() {
        return ((ApiKeyDAO)this.dao()).browsePrincipals();
    }

    protected boolean userExists(PrincipalCollection principals) {
        try {
            this.principalsHelper.getUserStatus(principals);
            return true;
        }
        catch (UserNotFoundException e) {
            this.log.debug("Stale user found", (Throwable)e);
            return false;
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(UserPrincipalsExpired event) {
        String userId = event.getUserId();
        if (userId != null) {
            this.deleteApiKeys((PrincipalCollection)new SimplePrincipalCollection((Object)userId, event.getSource()));
        } else {
            this.purgeApiKeys();
        }
    }

    @Transactional
    public Collection<ApiKey> browse(String domain) {
        return ((ApiKeyDAO)this.dao()).browse(domain);
    }

    @Transactional
    public Collection<ApiKey> browseByCreatedDate(String domain, OffsetDateTime date) {
        return ((ApiKeyDAO)this.dao()).browseByCreatedDate(domain, date);
    }

    @Transactional
    public int count(String domain) {
        return ((ApiKeyDAO)this.dao()).count(domain);
    }

    @Transactional
    public void deleteApiKeys(String domain) {
        ((ApiKeyDAO)this.dao()).deleteApiKeysByDomain(domain);
    }

    @Transactional
    public void deleteApiKeys(OffsetDateTime expiration) {
        ((ApiKeyDAO)this.dao()).deleteApiKeyByExpirationDate(expiration);
    }

    @Transactional
    public void updateApiKey(ApiKey from, ApiKey to) {
        ApiKeyData fromApiKey = (ApiKeyData)from;
        fromApiKey.setApiKey(to.getApiKey());
        fromApiKey.setPrincipals(to.getPrincipals());
        fromApiKey.setCreated(to.getCreated());
        ((ApiKeyDAO)this.dao()).update(fromApiKey);
    }

    @Transactional
    public Collection<ApiKey> browsePaginated(String domain, int page, int pageSize) {
        return ((ApiKeyDAO)this.dao()).browsePaginated(domain, (page - 1) * pageSize, pageSize);
    }

    private Optional<ApiKey> findApiKey(String domain, PrincipalCollection principals) {
        return ((ApiKeyDAO)this.dao()).findApiKeys(domain, principals.getPrimaryPrincipal().toString()).stream().filter(this.principalMatches(principals)).findAny();
    }

    private Predicate<ApiKey> principalMatches(PrincipalCollection principals) {
        String primaryPrincipal = principals.getPrimaryPrincipal().toString();
        Set realms = principals.getRealmNames();
        return key -> key.getPrincipals().getRealmNames().equals(realms) && key.getPrincipals().getPrimaryPrincipal().equals(primaryPrincipal);
    }
}

