/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.apikey;

import com.google.common.base.Preconditions;
import java.time.OffsetDateTime;
import org.apache.shiro.subject.PrincipalCollection;
import org.sonatype.nexus.internal.security.apikey.ApiKeyToken;
import org.sonatype.nexus.security.authc.apikey.ApiKey;

public class ApiKeyData
implements ApiKey {
    private String domain;
    private PrincipalCollection principals;
    private ApiKeyToken token;
    private OffsetDateTime created;

    ApiKeyData() {
    }

    ApiKeyData(String domain, PrincipalCollection principals, ApiKeyToken token, OffsetDateTime created) {
        this.domain = (String)Preconditions.checkNotNull((Object)domain);
        this.principals = (PrincipalCollection)Preconditions.checkNotNull((Object)principals);
        this.token = (ApiKeyToken)Preconditions.checkNotNull((Object)token);
        this.created = created;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setPrincipals(PrincipalCollection principals) {
        this.principals = principals;
    }

    public void setToken(ApiKeyToken token) {
        this.token = token;
    }

    public void setApiKey(char[] chars) {
        this.token = new ApiKeyToken(chars);
    }

    public String getDomain() {
        return this.domain;
    }

    public PrincipalCollection getPrincipals() {
        return this.principals;
    }

    public ApiKeyToken getToken() {
        return this.token;
    }

    public char[] getApiKey() {
        return this.token.getChars();
    }

    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }
}

