/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.script.groovy;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.internal.script.groovy.GroovyScriptEngineFactory;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
public class GroovyScriptEngineLoader
extends StateGuardLifecycleSupport {
    private final ClassLoader classLoader;
    private final ApplicationDirectories applicationDirectories;
    private final ScriptEngineManager scriptEngineManager;

    @Inject
    public GroovyScriptEngineLoader(@Named(value="nexus-uber") @Named(value="nexus-uber") ClassLoader classLoader, ApplicationDirectories applicationDirectories, ScriptEngineManager scriptEngineManager) {
        this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader);
        this.applicationDirectories = (ApplicationDirectories)Preconditions.checkNotNull((Object)applicationDirectories);
        this.scriptEngineManager = (ScriptEngineManager)Preconditions.checkNotNull((Object)scriptEngineManager);
    }

    protected void doStart() throws Exception {
        GroovyScriptEngineFactory groovyEngineFactory = new GroovyScriptEngineFactory(this.classLoader, this.applicationDirectories);
        this.log.debug("Registering engine-factory: {}", (Object)groovyEngineFactory);
        groovyEngineFactory.getNames().forEach(name -> this.scriptEngineManager.registerEngineName((String)name, (ScriptEngineFactory)((Object)groovyEngineFactory)));
    }
}

