/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.script;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.eclipse.sisu.inject.BeanLocator;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.GlobalComponentLookupHelper;
import org.sonatype.nexus.common.script.ScriptApi;
import org.sonatype.nexus.common.script.ScriptCleanupHandler;
import org.sonatype.nexus.common.script.ScriptService;
import org.sonatype.nexus.internal.script.IllegalScriptLanguageException;

@Named
@Singleton
public class ScriptServiceImpl
extends ComponentSupport
implements ScriptService {
    public static final String SCRIPT_CLEANUP_HANDLER = "scriptCleanupHandler";
    private final ScriptEngineManager engineManager;
    private final BeanLocator beanLocator;
    private final GlobalComponentLookupHelper lookupHelper;
    private final List<ScriptApi> scriptApis;
    private final ScriptCleanupHandler scriptCleanupHandler;
    private final boolean allowOnlyGroovy;

    @Inject
    public ScriptServiceImpl(ScriptEngineManager engineManager, BeanLocator beanLocator, GlobalComponentLookupHelper lookupHelper, List<ScriptApi> scriptApis, ScriptCleanupHandler scriptCleanupHandler, @Named(value="${nexus.scripts.groovyOnly:-true}") @Named(value="${nexus.scripts.groovyOnly:-true}") boolean allowOnlyGroovy) {
        this.engineManager = (ScriptEngineManager)Preconditions.checkNotNull((Object)engineManager);
        this.beanLocator = (BeanLocator)Preconditions.checkNotNull((Object)beanLocator);
        this.lookupHelper = (GlobalComponentLookupHelper)Preconditions.checkNotNull((Object)lookupHelper);
        this.scriptApis = (List)Preconditions.checkNotNull(scriptApis);
        this.scriptCleanupHandler = (ScriptCleanupHandler)Preconditions.checkNotNull((Object)scriptCleanupHandler);
        this.allowOnlyGroovy = allowOnlyGroovy;
    }

    @Nonnull
    public ScriptEngine engineForLanguage(String language) {
        this.validateLanguage(language);
        this.log.trace("Resolving engine for language: {}", (Object)language);
        ScriptEngine engine = this.engineManager.getEngineByName(language);
        Preconditions.checkState((engine != null ? 1 : 0) != 0, (String)"Missing engine for language: %s", (Object)language);
        this.log.trace("Engine: {}", (Object)engine);
        return engine;
    }

    public void applyDefaultBindings(Bindings bindings) {
        Preconditions.checkNotNull((Object)bindings);
        bindings.put("beanLocator", (Object)this.beanLocator);
        bindings.put("container", (Object)this.lookupHelper);
        bindings.put(SCRIPT_CLEANUP_HANDLER, (Object)this.scriptCleanupHandler);
        for (ScriptApi scriptApi : this.scriptApis) {
            bindings.put(scriptApi.getName(), (Object)scriptApi);
        }
    }

    @Nonnull
    public ScriptContext createContext(String language) {
        SimpleScriptContext context = new SimpleScriptContext();
        context.setBindings(this.engineForLanguage(language).createBindings(), 100);
        return context;
    }

    public void customizeBindings(ScriptContext context, int scope, Map<String, Object> customizations) {
        Bindings bindings = context.getBindings(scope);
        this.applyDefaultBindings(bindings);
        for (Map.Entry<String, Object> entry : customizations.entrySet()) {
            bindings.put(entry.getKey(), entry.getValue());
        }
    }

    public void customizeBindings(ScriptContext context, Map<String, Object> customizations) {
        this.customizeBindings(context, 100, customizations);
    }

    public Object eval(String language, String script, ScriptContext context) throws ScriptException {
        return this.engineForLanguage((String)Preconditions.checkNotNull((Object)language)).eval((String)Preconditions.checkNotNull((Object)script), (ScriptContext)Preconditions.checkNotNull((Object)context));
    }

    public Object eval(String language, String script, Map<String, Object> customBindings) throws ScriptException {
        ScriptContext context = this.createContext(language);
        this.customizeBindings(context, customBindings);
        return this.eval(language, script, context);
    }

    private void validateLanguage(String language) {
        Preconditions.checkNotNull((Object)language);
        if (this.allowOnlyGroovy && !language.equals("groovy")) {
            throw new IllegalScriptLanguageException("Language: " + language + " is not allowed");
        }
    }
}

