/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.script;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditorSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.script.Script;
import org.sonatype.nexus.script.ScriptCreatedEvent;
import org.sonatype.nexus.script.ScriptDeletedEvent;
import org.sonatype.nexus.script.ScriptEvent;
import org.sonatype.nexus.script.ScriptUpdatedEvent;

@Named
@Singleton
public class ScriptAuditor
extends AuditorSupport
implements EventAware {
    public static final String DOMAIN = "script";

    public ScriptAuditor() {
        this.registerType(ScriptCreatedEvent.class, "created");
        this.registerType(ScriptDeletedEvent.class, "deleted");
        this.registerType(ScriptUpdatedEvent.class, "updated");
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(ScriptEvent event) {
        if (this.isRecording()) {
            Script script = event.getScript();
            AuditData data = new AuditData();
            data.setDomain(DOMAIN);
            data.setType(this.type(event.getClass()));
            data.setContext(script.getName());
            Map attributes = data.getAttributes();
            attributes.put("name", script.getName());
            attributes.put("type", script.getType());
            this.record(data);
        }
    }
}

