/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.scheduling;

import com.google.common.base.Preconditions;
import java.net.URL;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.template.TemplateHelper;
import org.sonatype.nexus.common.template.TemplateParameters;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskNotificationMessageGenerator;

@Singleton
@Named(value="DEFAULT")
public class DefaultTaskNotificationMessageGenerator
extends ComponentSupport
implements TaskNotificationMessageGenerator {
    public static final String ID = "DEFAULT";
    private final TemplateHelper templateHelper;

    @Inject
    public DefaultTaskNotificationMessageGenerator(TemplateHelper templateHelper) {
        this.templateHelper = (TemplateHelper)Preconditions.checkNotNull((Object)templateHelper);
    }

    public String completed(TaskInfo taskInfo) {
        URL template = DefaultTaskNotificationMessageGenerator.class.getResource("task-completed.vm");
        TemplateParameters params = new TemplateParameters();
        String formattedDuration = DateTimeFormatter.ISO_LOCAL_TIME.format(LocalTime.MIDNIGHT.plus(taskInfo.getLastRunState().getRunDuration(), ChronoUnit.MILLIS));
        params.set("formattedDuration", (Object)formattedDuration);
        params.set("taskInfo", (Object)taskInfo);
        return this.templateHelper.render(template, params);
    }

    public String failed(TaskInfo taskInfo, Throwable cause) {
        URL template = DefaultTaskNotificationMessageGenerator.class.getResource("task-failed.vm");
        TemplateParameters params = new TemplateParameters();
        params.set("taskInfo", (Object)taskInfo);
        if (cause != null) {
            params.set("stackTrace", (Object)ExceptionUtils.getStackTrace((Throwable)cause));
        }
        return this.templateHelper.render(template, params);
    }
}

