/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.httpclient.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.httpclient.config.HttpClientConfiguration;
import org.sonatype.nexus.internal.httpclient.HttpClientConfigurationStore;
import org.sonatype.nexus.internal.httpclient.orient.OrientHttpClientConfiguration;
import org.sonatype.nexus.internal.httpclient.orient.OrientHttpClientConfigurationEntityAdapter;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;

@Named(value="orient")
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientHttpClientConfigurationStore
extends StateGuardLifecycleSupport
implements HttpClientConfigurationStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final OrientHttpClientConfigurationEntityAdapter entityAdapter;

    @Inject
    public OrientHttpClientConfigurationStore(@Named(value="config") @Named(value="config") Provider<DatabaseInstance> databaseInstance, OrientHttpClientConfigurationEntityAdapter entityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (OrientHttpClientConfigurationEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
    }

    protected void doStart() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Nullable
    @Guarded(by={"STARTED"})
    public HttpClientConfiguration load() {
        return (HttpClientConfiguration)OrientTransactional.inTx(this.databaseInstance).call(arg_0 -> ((OrientHttpClientConfigurationEntityAdapter)this.entityAdapter).get(arg_0));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void save(HttpClientConfiguration configuration) {
        Preconditions.checkArgument((boolean)(configuration instanceof OrientHttpClientConfiguration), (Object)"HttpClientConfiguration does not match backing store");
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            boolean bl = this.entityAdapter.set(db, (Entity)((OrientHttpClientConfiguration)configuration));
        });
    }

    @Override
    public HttpClientConfiguration newConfiguration() {
        return new OrientHttpClientConfiguration();
    }
}

