/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.httpclient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.Valid;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.RedirectStrategy;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.httpclient.config.AuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.ConnectionConfiguration;
import org.sonatype.nexus.httpclient.config.HttpClientConfiguration;
import org.sonatype.nexus.httpclient.config.ProxyConfiguration;
import org.sonatype.nexus.internal.httpclient.HttpClientConfigurationStore;

@Named(value="memory")
@Singleton
@Priority(value=-2147483648)
@VisibleForTesting
public class MemoryHttpClientConfigurationStore
extends ComponentSupport
implements HttpClientConfigurationStore {
    private HttpClientConfiguration model;

    @Override
    @Nullable
    public synchronized HttpClientConfiguration load() {
        return this.model;
    }

    @Override
    public synchronized void save(HttpClientConfiguration configuration) {
        this.model = (HttpClientConfiguration)Preconditions.checkNotNull((Object)configuration);
    }

    @Override
    public HttpClientConfiguration newConfiguration() {
        return new MemoryHttpClientConfiguration();
    }

    private static class MemoryHttpClientConfiguration
    implements HttpClientConfiguration,
    Cloneable {
        @Valid
        @Nullable
        private ConnectionConfiguration connection;
        @Valid
        @Nullable
        private ProxyConfiguration proxy;
        @Valid
        @Nullable
        private RedirectStrategy redirectStrategy;
        @Valid
        @Nullable
        private AuthenticationConfiguration authentication;
        @Valid
        @Nullable
        private AuthenticationStrategy authenticationStrategy;
        @Valid
        @Nullable
        private Boolean shouldNormalizeUri;
        @Valid
        @Nullable
        private Boolean disableContentCompression;

        MemoryHttpClientConfiguration() {
        }

        @Nullable
        public ConnectionConfiguration getConnection() {
            return this.connection;
        }

        public void setConnection(@Nullable ConnectionConfiguration connection) {
            this.connection = connection;
        }

        @Nullable
        public ProxyConfiguration getProxy() {
            return this.proxy;
        }

        public void setProxy(@Nullable ProxyConfiguration proxy) {
            this.proxy = proxy;
        }

        @Nullable
        public AuthenticationConfiguration getAuthentication() {
            return this.authentication;
        }

        public void setAuthentication(@Nullable AuthenticationConfiguration authentication) {
            this.authentication = authentication;
        }

        @Nullable
        public RedirectStrategy getRedirectStrategy() {
            return this.redirectStrategy;
        }

        public void setRedirectStrategy(@Nullable RedirectStrategy redirectStrategy) {
            this.redirectStrategy = redirectStrategy;
        }

        @Nullable
        public AuthenticationStrategy getAuthenticationStrategy() {
            return this.authenticationStrategy;
        }

        public void setAuthenticationStrategy(@Nullable AuthenticationStrategy authenticationStrategy) {
            this.authenticationStrategy = authenticationStrategy;
        }

        public Boolean getNormalizeUri() {
            return this.shouldNormalizeUri;
        }

        public void setNormalizeUri(Boolean normalizeUri) {
            this.shouldNormalizeUri = normalizeUri;
        }

        public Boolean getDisableContentCompression() {
            return this.disableContentCompression;
        }

        public void setDisableContentCompression(Boolean disableContentCompression) {
            this.disableContentCompression = disableContentCompression;
        }

        public MemoryHttpClientConfiguration copy() {
            try {
                MemoryHttpClientConfiguration copy = (MemoryHttpClientConfiguration)this.clone();
                if (this.connection != null) {
                    copy.connection = this.connection.copy();
                }
                if (this.proxy != null) {
                    copy.proxy = this.proxy.copy();
                }
                if (this.authentication != null) {
                    copy.authentication = this.authentication.copy();
                }
                if (this.redirectStrategy != null) {
                    copy.redirectStrategy = this.redirectStrategy;
                }
                copy.shouldNormalizeUri = this.shouldNormalizeUri;
                copy.disableContentCompression = this.disableContentCompression;
                return copy;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "connection=" + this.connection + ", proxy=" + this.proxy + ", authentication=" + this.authentication + '}';
        }
    }
}

