/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.httpclient;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.httpclient.config.HttpClientConfiguration;
import org.sonatype.nexus.internal.httpclient.HttpClientConfigurationData;
import org.sonatype.nexus.internal.httpclient.HttpClientConfigurationStore;
import org.sonatype.nexus.supportzip.ExportConfigData;
import org.sonatype.nexus.supportzip.ImportData;
import org.sonatype.nexus.supportzip.datastore.JsonExporter;

@Named(value="httpClientConfigurationExport")
@Singleton
public class HttpClientConfigurationExport
extends JsonExporter
implements ExportConfigData,
ImportData {
    private final HttpClientConfigurationStore store;

    @Inject
    public HttpClientConfigurationExport(HttpClientConfigurationStore store) {
        this.store = store;
    }

    public void export(File file) throws IOException {
        this.log.debug("Export HttpClientConfiguration data to {}", (Object)file);
        HttpClientConfiguration configuration = this.store.load();
        this.exportObjectToJson(configuration, file);
    }

    public void restore(File file) throws IOException {
        this.log.debug("Restoring HttpClientConfiguration data from {}", (Object)file);
        Optional configuration = this.importObjectFromJson(file, HttpClientConfigurationData.class);
        configuration.ifPresent(this.store::save);
    }
}

