/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.email.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.sonatype.nexus.internal.email.rest.ApiEmailConfiguration;
import org.sonatype.nexus.internal.email.rest.ApiEmailValidation;

@Api(value="Email")
public interface EmailConfigurationApiResourceDoc {
    @ApiOperation(value="Retrieve the current email configuration")
    @ApiResponses(value={@ApiResponse(code=403, message="Insufficient permissions to retrieve the email configuration")})
    public ApiEmailConfiguration getEmailConfiguration();

    @ApiOperation(value="Set the current email configuration")
    @ApiResponses(value={@ApiResponse(code=204, message="Email configuration was successfully updated"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="Insufficient permissions to update the email configuration")})
    public void setEmailConfiguration(@ApiParam(required=true) @NotNull @Valid ApiEmailConfiguration var1);

    @ApiOperation(value="Send a test email to the email address provided in the request body")
    @ApiResponses(value={@ApiResponse(code=200, message="Validation was complete, look at the body to determine success", response=ApiEmailValidation.class), @ApiResponse(code=403, message="Insufficient permissions to verify the email configuration")})
    public ApiEmailValidation testEmailConfiguration(@ApiParam(required=true, value="An email address to send a test email to") @NotNull String var1);

    @ApiOperation(value="Disable and clear the email configuration")
    @ApiResponses(value={@ApiResponse(code=204, message="Email configuration was successfully cleared")})
    public void deleteEmailConfiguration();
}

