/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.email.rest;

import javax.inject.Inject;
import javax.mail.internet.AddressException;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.EmailException;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.email.EmailConfiguration;
import org.sonatype.nexus.email.EmailManager;
import org.sonatype.nexus.internal.email.rest.ApiEmailConfiguration;
import org.sonatype.nexus.internal.email.rest.ApiEmailValidation;
import org.sonatype.nexus.internal.email.rest.EmailConfigurationApiResourceDoc;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;
import org.sonatype.nexus.validation.Validate;

@Produces(value={"application/json"})
public class EmailConfigurationApiResource
implements Resource,
EmailConfigurationApiResourceDoc {
    private static final Logger log = LoggerFactory.getLogger(EmailConfigurationApiResource.class);
    private final EmailManager emailManager;

    @Inject
    public EmailConfigurationApiResource(EmailManager emailManager) {
        this.emailManager = emailManager;
    }

    @Override
    @GET
    @RequiresPermissions(value={"nexus:settings:read"})
    public ApiEmailConfiguration getEmailConfiguration() {
        return this.convert(this.emailManager.getConfiguration());
    }

    @Override
    @PUT
    @RequiresAuthentication
    @Validate
    @RequiresPermissions(value={"nexus:settings:update"})
    public void setEmailConfiguration(@NotNull @Valid ApiEmailConfiguration apiEmailConfiguration) {
        EmailConfiguration emailConfiguration = this.emailManager.getConfiguration();
        String password = emailConfiguration != null ? emailConfiguration.getPassword() : null;
        this.emailManager.setConfiguration(this.convert(apiEmailConfiguration, password));
    }

    @Override
    @POST
    @Path(value="/verify")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:settings:update"})
    public ApiEmailValidation testEmailConfiguration(@NotNull String verificationAddress) {
        EmailConfiguration emailConfiguration = this.emailManager.getConfiguration();
        if (emailConfiguration == null) {
            return new ApiEmailValidation(false, "Email Settings are not yet configured");
        }
        try {
            this.emailManager.sendVerification(emailConfiguration, verificationAddress);
            return new ApiEmailValidation(true);
        }
        catch (EmailException e) {
            log.debug("Unable to send verification", (Throwable)e);
            String exceptionMessage = e.getMessage().replace(String.valueOf(e.getCause().getClass().getName()) + ": ", "");
            if (e.getCause() instanceof AddressException) {
                throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)(String.valueOf('\"') + exceptionMessage + '\"'), "application/json");
            }
            return new ApiEmailValidation(false, exceptionMessage);
        }
    }

    @Override
    @DELETE
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:settings:update"})
    public void deleteEmailConfiguration() {
        this.emailManager.setConfiguration(this.emailManager.newConfiguration());
    }

    private EmailConfiguration convert(ApiEmailConfiguration apiEmailConfiguration, String originalPassword) {
        String password = apiEmailConfiguration.getPassword();
        boolean hasPassword = !StringUtils.isBlank((CharSequence)password);
        EmailConfiguration emailConfiguration = this.emailManager.newConfiguration();
        emailConfiguration.setEnabled(apiEmailConfiguration.isEnabled());
        emailConfiguration.setHost(apiEmailConfiguration.getHost());
        emailConfiguration.setPort(apiEmailConfiguration.getPort() == null ? 0 : apiEmailConfiguration.getPort());
        emailConfiguration.setNexusTrustStoreEnabled(apiEmailConfiguration.isNexusTrustStoreEnabled());
        if (StringUtils.isNotEmpty((CharSequence)apiEmailConfiguration.getUsername())) {
            emailConfiguration.setUsername(apiEmailConfiguration.getUsername());
        } else {
            emailConfiguration.setUsername("");
        }
        if (hasPassword) {
            emailConfiguration.setPassword(password);
        } else if (StringUtils.isNotEmpty((CharSequence)originalPassword)) {
            emailConfiguration.setPassword(originalPassword);
        } else {
            emailConfiguration.setPassword("");
        }
        emailConfiguration.setFromAddress(apiEmailConfiguration.getFromAddress());
        emailConfiguration.setSubjectPrefix(apiEmailConfiguration.getSubjectPrefix());
        emailConfiguration.setStartTlsEnabled(apiEmailConfiguration.isStartTlsEnabled());
        emailConfiguration.setStartTlsRequired(apiEmailConfiguration.isStartTlsRequired());
        emailConfiguration.setSslOnConnectEnabled(apiEmailConfiguration.isSslOnConnectEnabled());
        emailConfiguration.setSslCheckServerIdentityEnabled(apiEmailConfiguration.isSslServerIdentityCheckEnabled());
        return emailConfiguration;
    }

    private ApiEmailConfiguration convert(EmailConfiguration emailConfiguration) {
        if (emailConfiguration == null) {
            return new ApiEmailConfiguration();
        }
        ApiEmailConfiguration apiEmailConfiguration = new ApiEmailConfiguration();
        apiEmailConfiguration.setEnabled(emailConfiguration.isEnabled());
        apiEmailConfiguration.setHost(emailConfiguration.getHost());
        apiEmailConfiguration.setPort(emailConfiguration.getPort());
        apiEmailConfiguration.setNexusTrustStoreEnabled(emailConfiguration.isNexusTrustStoreEnabled());
        apiEmailConfiguration.setUsername(emailConfiguration.getUsername());
        apiEmailConfiguration.setPassword(null);
        apiEmailConfiguration.setFromAddress(emailConfiguration.getFromAddress());
        apiEmailConfiguration.setSubjectPrefix(emailConfiguration.getSubjectPrefix());
        apiEmailConfiguration.setStartTlsEnabled(emailConfiguration.isStartTlsEnabled());
        apiEmailConfiguration.setStartTlsRequired(emailConfiguration.isStartTlsRequired());
        apiEmailConfiguration.setSslOnConnectEnabled(emailConfiguration.isSslOnConnectEnabled());
        apiEmailConfiguration.setSslServerIdentityCheckEnabled(emailConfiguration.isSslCheckServerIdentityEnabled());
        return apiEmailConfiguration;
    }
}

