/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.email.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.email.EmailConfiguration;
import org.sonatype.nexus.internal.email.EmailConfigurationStore;
import org.sonatype.nexus.internal.email.orient.OrientEmailConfiguration;
import org.sonatype.nexus.internal.email.orient.OrientEmailConfigurationEntityAdapter;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;

@Named(value="orient")
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientEmailConfigurationStore
extends StateGuardLifecycleSupport
implements EmailConfigurationStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final OrientEmailConfigurationEntityAdapter entityAdapter;

    @Inject
    public OrientEmailConfigurationStore(@Named(value="config") @Named(value="config") Provider<DatabaseInstance> databaseInstance, OrientEmailConfigurationEntityAdapter entityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (OrientEmailConfigurationEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
    }

    protected void doStart() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Nullable
    @Guarded(by={"STARTED"})
    public EmailConfiguration load() {
        return (EmailConfiguration)OrientTransactional.inTx(this.databaseInstance).call(arg_0 -> ((OrientEmailConfigurationEntityAdapter)this.entityAdapter).get(arg_0));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void save(EmailConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkArgument((boolean)(configuration instanceof OrientEmailConfiguration), (Object)"Configuration arg must be an instance of OrientEmailConfiguration");
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            boolean bl = this.entityAdapter.set(db, (Entity)((OrientEmailConfiguration)configuration));
        });
    }

    @Override
    public EmailConfiguration newConfiguration() {
        return new OrientEmailConfiguration();
    }
}

