/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.email;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.eventbus.Subscribe;
import java.util.Properties;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.mail.Session;
import javax.net.ssl.SSLContext;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Mutex;
import org.sonatype.nexus.capability.CapabilityContext;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventConsumer;
import org.sonatype.nexus.common.event.EventHelper;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.email.EmailConfiguration;
import org.sonatype.nexus.email.EmailConfigurationChangedEvent;
import org.sonatype.nexus.email.EmailManager;
import org.sonatype.nexus.internal.email.EmailConfigurationEvent;
import org.sonatype.nexus.internal.email.EmailConfigurationStore;
import org.sonatype.nexus.ssl.TrustStore;

@Named
@Singleton
public class EmailManagerImpl
extends ComponentSupport
implements EmailManager,
EventAware {
    private final EventManager eventManager;
    private final EmailConfigurationStore store;
    private final TrustStore trustStore;
    private final Function<EmailConfiguration, EmailConfiguration> defaults;
    private final Mutex lock = new Mutex();
    private final Provider<CapabilityRegistry> capabilityRegistryProvider;
    private EmailConfiguration configuration;

    @Inject
    public EmailManagerImpl(EventManager eventManager, EmailConfigurationStore store, TrustStore trustStore, @Named(value="initial") @Named(value="initial") Function<EmailConfiguration, EmailConfiguration> defaults, Provider<CapabilityRegistry> capabilityRegistryProvider) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.store = (EmailConfigurationStore)Preconditions.checkNotNull((Object)store);
        this.trustStore = (TrustStore)Preconditions.checkNotNull((Object)trustStore);
        this.defaults = (Function)Preconditions.checkNotNull(defaults);
        this.capabilityRegistryProvider = capabilityRegistryProvider;
    }

    private EmailConfiguration loadConfiguration() {
        EmailConfiguration model = this.store.load();
        if (model == null) {
            model = this.defaults.apply(this.store.newConfiguration());
            Preconditions.checkNotNull((Object)model);
            this.log.info("Using default configuration: {}", (Object)model);
        } else {
            this.log.info("Loaded configuration: {}", (Object)model);
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EmailConfiguration getConfigurationInternal() {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            if (this.configuration == null) {
                this.configuration = this.loadConfiguration();
            }
            return this.configuration;
        }
    }

    public EmailConfiguration getConfiguration() {
        return this.getConfigurationInternal().copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfiguration(EmailConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        EmailConfiguration model = configuration.copy();
        this.log.info("Saving configuration: {}", (Object)model);
        Mutex mutex = this.lock;
        synchronized (mutex) {
            if (!EventHelper.isReplicating()) {
                this.store.save(model);
            }
            this.configuration = model;
        }
        this.eventManager.post((Object)new EmailConfigurationChangedEvent(model));
    }

    @VisibleForTesting
    Email apply(EmailConfiguration configuration, Email mail) throws EmailException {
        String subjectPrefix;
        mail.setHostName(configuration.getHost());
        mail.setSmtpPort(configuration.getPort());
        if (!Strings.isNullOrEmpty((String)configuration.getUsername()) || !Strings.isNullOrEmpty((String)configuration.getPassword())) {
            mail.setAuthentication(configuration.getUsername(), configuration.getPassword());
        }
        mail.setStartTLSEnabled(configuration.isStartTlsEnabled());
        mail.setStartTLSRequired(configuration.isStartTlsRequired());
        mail.setSSLOnConnect(configuration.isSslOnConnectEnabled());
        mail.setSSLCheckServerIdentity(configuration.isSslCheckServerIdentityEnabled());
        mail.setSslSmtpPort(Integer.toString(configuration.getPort()));
        if (mail.getFromAddress() == null) {
            mail.setFrom(configuration.getFromAddress());
        }
        if ((subjectPrefix = configuration.getSubjectPrefix()) != null) {
            String subject = mail.getSubject();
            mail.setSubject(String.format("%s %s", subjectPrefix, subject));
        }
        if (configuration.isNexusTrustStoreEnabled()) {
            SSLContext context = this.trustStore.getSSLContext();
            Session session = mail.getMailSession();
            Properties properties = session.getProperties();
            properties.remove("mail.smtp.socketFactory.class");
            properties.put("mail.smtp.ssl.enable", (Object)true);
            properties.put("mail.smtp.ssl.socketFactory", context.getSocketFactory());
        }
        return mail;
    }

    public void send(Email mail) throws EmailException {
        Preconditions.checkNotNull((Object)mail);
        EmailConfiguration model = this.getConfigurationInternal();
        if (model.isEnabled()) {
            Email prepared = this.apply(model, mail);
            this.sendMail(prepared);
        } else {
            this.log.warn("No email enabled but asked to send anyway.");
        }
    }

    public void sendVerification(EmailConfiguration configuration, String address) throws EmailException {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)address);
        SimpleEmail mail = new SimpleEmail();
        mail.setSubject("Email configuration verification");
        mail.addTo(address);
        mail.setMsg(this.constructMessage("Verification successful"));
        mail = this.apply(configuration, (Email)mail);
        this.sendMail((Email)mail);
    }

    public EmailConfiguration newConfiguration() {
        return this.store.newConfiguration();
    }

    public String constructMessage(String message) {
        return ((CapabilityRegistry)this.capabilityRegistryProvider.get()).getAll().stream().map(CapabilityReference::context).filter(context -> context.type().toString().equals("baseurl")).filter(CapabilityContext::isEnabled).map(capabilityContext -> (String)capabilityContext.properties().get("url")).findFirst().map(url -> "Message from: " + url + "\n\n" + message).orElse(message);
    }

    @Subscribe
    public void onStoreChanged(EmailConfigurationEvent event) {
        this.handleReplication(event, (EventConsumer<EmailConfigurationEvent>)((EventConsumer)e -> this.setConfiguration(e.getEmailConfiguration())));
    }

    private void handleReplication(EmailConfigurationEvent event, EventConsumer<EmailConfigurationEvent> consumer) {
        if (!event.isLocal()) {
            try {
                consumer.accept((Object)event);
            }
            catch (Exception e) {
                this.log.error("Failed to replicate: {}", (Object)event, (Object)e);
            }
        }
    }

    private void sendMail(Email mail) throws EmailException {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Session.class.getClassLoader());
            mail.send();
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }
}

