/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.datastore.task;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Consumer;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.internal.datastore.task.SqlScriptGenerationException;
import org.sonatype.nexus.scheduling.CancelableHelper;

public class H2TaskSupport
extends ComponentSupport {
    private static final String EXPORT_INITIALISE_SQL = "ALTER TABLE \"PUBLIC\".\"NUGET_COMPONENT\" ALTER COLUMN CI_NAME VARCHAR NOT NULL SELECTIVITY 100;";
    private static final String EXPORT_SQL = "SCRIPT";
    private static final String EXPORT_RECOVERY_SQL = "ALTER TABLE \"PUBLIC\".\"NUGET_COMPONENT\" ALTER COLUMN CI_NAME VARCHAR AS LOWER(\"NAME\") SELECTIVITY 100;";
    static final int PROGRESS_UPDATE_THRESHOLD = 10000;
    static final int PROGRESS_LOG_THRESHOLD = 500000;

    public long exportDatabase(Connection connection, String location, Consumer<String> progressConsumer) throws SqlScriptGenerationException {
        boolean autoCommit = false;
        try {
            long l;
            block25: {
                PreparedStatement scriptStmt;
                autoCommit = this.getAndSetAutoCommit(connection);
                Throwable throwable = null;
                Object var6_9 = null;
                try {
                    scriptStmt = connection.prepareStatement(EXPORT_INITIALISE_SQL);
                    try {
                        scriptStmt.execute();
                    }
                    finally {
                        if (scriptStmt != null) {
                            scriptStmt.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                throwable = null;
                var6_9 = null;
                scriptStmt = connection.prepareStatement(EXPORT_SQL);
                try {
                    scriptStmt.execute();
                    l = this.processResults(scriptStmt.getResultSet(), location, progressConsumer);
                    if (scriptStmt == null) break block25;
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            if (scriptStmt != null) {
                                scriptStmt.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                    }
                    catch (SQLException ex) {
                        throw new SqlScriptGenerationException("Script generation failed", ex);
                    }
                }
                scriptStmt.close();
            }
            return l;
        }
        finally {
            this.rollback(connection);
            this.resetAutoCommit(connection, autoCommit);
        }
    }

    /*
     * Loose catch block
     */
    @VisibleForTesting
    long processResults(ResultSet resultSet, String location, Consumer<String> progressConsumer) throws SQLException {
        if (resultSet != null && location != null && !location.isEmpty()) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    long l;
                    BufferedWriter buffer;
                    FileWriter writer;
                    block19: {
                        block18: {
                            writer = new FileWriter(location);
                            buffer = new BufferedWriter(writer);
                            long linesWritten = this.writeLines(resultSet, progressConsumer, 10000, 500000, buffer);
                            l = linesWritten + 1L;
                            if (buffer == null) break block18;
                            buffer.close();
                        }
                        if (writer == null) break block19;
                        writer.close();
                    }
                    return l;
                    {
                        catch (Throwable throwable2) {
                            try {
                                if (buffer != null) {
                                    buffer.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (writer != null) {
                                    writer.close();
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                throw new SqlScriptGenerationException("Script generation failed when writing data", ex);
            }
        }
        return 0L;
    }

    @VisibleForTesting
    long writeLines(ResultSet resultSet, Consumer<String> progressConsumer, int progressUpdateThreshold, int progressLogThreshold, BufferedWriter buffer) throws SQLException, IOException {
        long linesWritten = 0L;
        while (resultSet.next()) {
            buffer.write(resultSet.getString(1));
            buffer.newLine();
            if (++linesWritten % (long)progressUpdateThreshold == 0L) {
                this.updateProgress(progressConsumer, linesWritten);
            }
            if (linesWritten % (long)progressLogThreshold != 0L) continue;
            this.log.info("Exported {} lines", (Object)linesWritten);
        }
        buffer.write(EXPORT_RECOVERY_SQL);
        buffer.newLine();
        buffer.flush();
        return linesWritten;
    }

    @VisibleForTesting
    void updateProgress(Consumer<String> progressConsumer, long linesWritten) {
        if (progressConsumer != null) {
            progressConsumer.accept(String.format("%d lines of SQL exported", linesWritten));
        }
        CancelableHelper.checkCancellation();
    }

    @VisibleForTesting
    void rollback(Connection connection) {
        try {
            connection.rollback();
        }
        catch (SQLException ex) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (PreparedStatement scriptStmt = connection.prepareStatement(EXPORT_RECOVERY_SQL);){
                    scriptStmt.execute();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException sQLException) {
                this.log.error("Unable to rollback export initialisation. The database may need modification.", (Throwable)ex);
                try {
                    connection.close();
                }
                catch (SQLException broken) {
                    throw new RuntimeException("Unable to close database connection after failed rollback:", broken);
                }
            }
        }
    }

    @VisibleForTesting
    boolean getAndSetAutoCommit(Connection connection) throws SQLException {
        boolean autoCommit = connection.getAutoCommit();
        connection.setAutoCommit(false);
        return autoCommit;
    }

    @VisibleForTesting
    void resetAutoCommit(Connection connection, boolean autoCommit) {
        try {
            connection.setAutoCommit(autoCommit);
        }
        catch (SQLException ex) {
            this.log.error("Unable to reset auto commit.", (Throwable)ex);
        }
    }
}

