/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.commands;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.sonatype.nexus.security.SecurityHelper;

@Named
@Command(name="login", scope="nexus", description="Put a user in context")
public class LoginAction
implements Action {
    private final SecurityHelper securityHelper;
    @Option(name="-u", aliases={"--username"}, description="Username to login with", required=true)
    String username;
    @Option(name="-p", aliases={"--password"}, description="Password to login with", required=true)
    String password;

    @Inject
    public LoginAction(SecurityHelper securityHelper) {
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
    }

    public Object execute() throws Exception {
        this.securityHelper.subject().login((AuthenticationToken)new UsernamePasswordToken(this.username, this.password));
        return null;
    }
}

