/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.commands;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.sonatype.nexus.common.app.FreezeService;

@Named
@Command(name="freeze", scope="nexus", description="Freeze Nexus Repository Manager")
public class FreezeAction
implements Action {
    private final FreezeService freezeService;
    @Option(name="-m", aliases={"--mode"}, description="Manage mode: enable or release (default enable)")
    Mode mode = Mode.enable;

    @Inject
    public FreezeAction(FreezeService freezeService) {
        this.freezeService = (FreezeService)Preconditions.checkNotNull((Object)freezeService);
    }

    public Object execute() throws Exception {
        switch (this.mode) {
            case enable: {
                this.freezeService.requestFreeze("console request");
                break;
            }
            case release: {
                this.freezeService.cancelFreeze();
            }
        }
        return null;
    }

    @VisibleForTesting
    static enum Mode {
        enable,
        release;

    }
}

