/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.capability.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;

@Named
@Singleton
@Upgrades(model="SettingsCapability", from="1.0", to="1.1")
@DependsOn(model="config", version="1.9", checkpoint=true)
public class SettingsCapabilityUpgrade_1_1
extends DatabaseUpgradeSupport {
    public static final String DEFAULT_REQUEST_TIMEOUT = "60";
    public static final String DEFAULT_LONG_REQUEST_TIMEOUT = "180";
    private static final String sql = "UPDATE capability SET properties.requestTimeout = '%s', properties.longRequestTimeout = '%s' WHERE type = 'rapture.settings' AND properties['requestTimeout'] IS NULL AND properties['longRequestTimeout'] IS NULL";
    private final OCommandSQL updatePropertiesQuery = new OCommandSQL(String.format("UPDATE capability SET properties.requestTimeout = '%s', properties.longRequestTimeout = '%s' WHERE type = 'rapture.settings' AND properties['requestTimeout'] IS NULL AND properties['longRequestTimeout'] IS NULL", "60", "180"));
    private final Provider<DatabaseInstance> configDatabaseInstance;

    @Inject
    public SettingsCapabilityUpgrade_1_1(@Named(value="config") @Named(value="config") Provider<DatabaseInstance> configDatabaseInstance) {
        this.configDatabaseInstance = (Provider)Preconditions.checkNotNull(configDatabaseInstance);
    }

    public void apply() throws Exception {
        SettingsCapabilityUpgrade_1_1.withDatabaseAndClass(this.configDatabaseInstance, (String)"capability", (db, type) -> {
            Object object = db.command((OCommandRequest)this.updatePropertiesQuery).execute(new Object[0]);
        });
    }
}

