/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.capability.upgrade;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.CapabilityIdentity;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorage;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorageItem;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationStep;

@Named
@Singleton
public class SettingsCapabilityMigrationStep_1_28
implements DatabaseMigrationStep {
    private final CapabilityStorage capabilityStorage;

    @Inject
    public SettingsCapabilityMigrationStep_1_28(CapabilityStorage capabilityStorage) {
        this.capabilityStorage = (CapabilityStorage)Preconditions.checkNotNull((Object)capabilityStorage);
    }

    public Optional<String> version() {
        return Optional.of("1.28");
    }

    public void migrate(Connection connection) throws Exception {
        this.capabilityStorage.getAll().entrySet().stream().filter(e -> ((CapabilityStorageItem)e.getValue()).getType().equals("rapture.settings")).findFirst().ifPresent(entry -> {
            CapabilityStorageItem capabilityStorageItem = (CapabilityStorageItem)entry.getValue();
            Map<String, String> properties = capabilityStorageItem.getProperties();
            properties.putIfAbsent("requestTimeout", "60");
            properties.putIfAbsent("longRequestTimeout", "180");
            this.capabilityStorage.update((CapabilityIdentity)entry.getKey(), capabilityStorageItem);
        });
    }
}

