/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.capability.storage.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.CapabilityIdentity;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorage;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorageItem;
import org.sonatype.nexus.internal.capability.storage.orient.OrientCapabilityStorageItem;
import org.sonatype.nexus.internal.capability.storage.orient.OrientCapabilityStorageItemEntityAdapter;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;

@Named(value="orient")
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientCapabilityStorage
extends StateGuardLifecycleSupport
implements CapabilityStorage {
    private final Provider<DatabaseInstance> databaseInstance;
    private final OrientCapabilityStorageItemEntityAdapter entityAdapter;

    @Inject
    public OrientCapabilityStorage(@Named(value="config") @Named(value="config") Provider<DatabaseInstance> databaseInstance, OrientCapabilityStorageItemEntityAdapter entityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (OrientCapabilityStorageItemEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private CapabilityIdentity identity(CapabilityStorageItem item) {
        OrientCapabilityStorage.checkEntityType(item);
        return OrientCapabilityStorageItem.identity(EntityHelper.id((Entity)((OrientCapabilityStorageItem)item)));
    }

    @Override
    @Guarded(by={"STARTED"})
    public CapabilityIdentity add(CapabilityStorageItem item) {
        OrientCapabilityStorage.checkEntityType(item);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            ODocument oDocument = this.entityAdapter.addEntity(db, (Entity)((OrientCapabilityStorageItem)item));
        });
        return this.identity(item);
    }

    @Override
    @Guarded(by={"STARTED"})
    public boolean update(CapabilityIdentity id, CapabilityStorageItem item) {
        OrientCapabilityStorage.checkEntityType(item);
        return (Boolean)OrientTransactional.inTxRetry(this.databaseInstance).call(db -> this.entityAdapter.edit(db, id.toString(), (OrientCapabilityStorageItem)item));
    }

    @Override
    @Guarded(by={"STARTED"})
    public boolean remove(CapabilityIdentity id) {
        return (Boolean)OrientTransactional.inTxRetry(this.databaseInstance).call(db -> this.entityAdapter.delete(db, id.toString()));
    }

    @Override
    @Guarded(by={"STARTED"})
    public Map<CapabilityIdentity, CapabilityStorageItem> getAll() {
        return (Map)OrientTransactional.inTx(this.databaseInstance).call(db -> Maps.uniqueIndex((Iterable)Iterables.transform((Iterable)this.entityAdapter.browse(db), e -> e), this::identity));
    }

    @Override
    public CapabilityStorageItem newStorageItem(int version, String type, boolean enabled, String notes, Map<String, String> properties) {
        return new OrientCapabilityStorageItem(version, type, enabled, notes, properties);
    }

    @Override
    public Map<CapabilityStorageItem, List<CapabilityIdentity>> browseCapabilityDuplicates() {
        return Collections.emptyMap();
    }

    @Override
    public boolean isDuplicatesFound() {
        return false;
    }

    private static void checkEntityType(CapabilityStorageItem item) {
        Preconditions.checkArgument((boolean)(item instanceof OrientCapabilityStorageItem), (Object)"CapabilityStorageItem does not match the backing implementation");
    }
}

