/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.capability.storage.datastore.cleanup;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.capability.CapabilityIdentity;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorage;

@Named
@Singleton
public class CleanupCapabilityDuplicatesService
extends ComponentSupport {
    private final CapabilityStorage capabilityStorage;

    @Inject
    public CleanupCapabilityDuplicatesService(CapabilityStorage capabilityStorage) {
        this.capabilityStorage = (CapabilityStorage)Preconditions.checkNotNull((Object)capabilityStorage);
    }

    public void doCleanup() {
        if (!this.capabilityStorage.isDuplicatesFound()) {
            this.log.debug("No capabilities duplicates found.");
            return;
        }
        this.capabilityStorage.browseCapabilityDuplicates().forEach((typeId, duplicates) -> {
            this.log.info("Cleaning up {} duplicates for {} capability", (Object)(duplicates.size() - 1), typeId);
            duplicates.stream().skip(1L).forEach(identity -> {
                if (this.capabilityStorage.remove((CapabilityIdentity)identity)) {
                    this.log.debug("Capability duplicate {} removed", identity);
                }
            });
        });
    }
}

