/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.capability.storage.datastore.cleanup;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.internal.capability.storage.datastore.cleanup.CleanupCapabilityDuplicatesService;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationStep;

@Named
@Singleton
public class CleanupCapabilityDuplicatesMigrationStep_1_27
implements DatabaseMigrationStep {
    private static final String ADD_INDEX = "CREATE UNIQUE INDEX IF NOT EXISTS uk_capability_storage_item_type_props ON capability_storage_item(type, properties)";
    private static final String ADD_CONSTRAINT = "ALTER TABLE capability_storage_item ADD CONSTRAINT IF NOT EXISTS uk_capability_storage_item_type_props UNIQUE (type, properties)";
    private final CleanupCapabilityDuplicatesService cleanupService;

    @Inject
    public CleanupCapabilityDuplicatesMigrationStep_1_27(CleanupCapabilityDuplicatesService cleanupService) {
        this.cleanupService = (CleanupCapabilityDuplicatesService)((Object)Preconditions.checkNotNull((Object)((Object)cleanupService)));
    }

    public Optional<String> version() {
        return Optional.of("1.27");
    }

    public void migrate(Connection connection) throws Exception {
        this.cleanupService.doCleanup();
        if (this.isPostgresql(connection)) {
            this.runStatement(connection, ADD_INDEX);
        } else {
            this.runStatement(connection, ADD_CONSTRAINT);
        }
    }
}

