/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.capability.storage;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.CapabilityIdentity;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.entity.EntityUUID;
import org.sonatype.nexus.common.entity.HasEntityId;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.datastore.api.DuplicateKeyException;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorage;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorageItem;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorageItemDAO;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorageItemData;
import org.sonatype.nexus.internal.capability.storage.datastore.CapabilityStorageItemCreatedEventImpl;
import org.sonatype.nexus.internal.capability.storage.datastore.CapabilityStorageItemDeletedEventImpl;
import org.sonatype.nexus.internal.capability.storage.datastore.CapabilityStorageItemUpdatedEventImpl;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class CapabilityStorageImpl
extends ConfigStoreSupport<CapabilityStorageItemDAO>
implements CapabilityStorage {
    @Inject
    public CapabilityStorageImpl(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier);
    }

    @Override
    public CapabilityStorageItem newStorageItem(int version, String type, boolean enabled, String notes, Map<String, String> properties) {
        CapabilityStorageItemData item = new CapabilityStorageItemData();
        item.setVersion(version);
        item.setType(type);
        item.setEnabled(enabled);
        item.setNotes(notes);
        item.setProperties(properties);
        return item;
    }

    @Override
    @Transactional
    public CapabilityIdentity add(CapabilityStorageItem item) {
        this.postCommitEvent(() -> new CapabilityStorageItemCreatedEventImpl((CapabilityStorageItemData)item));
        try {
            ((CapabilityStorageItemDAO)this.dao()).create((CapabilityStorageItemData)item);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            this.log.debug("Trying to add duplicate for {} capability. Ignore it.", (Object)item);
        }
        return CapabilityStorageImpl.capabilityIdentity(item);
    }

    @Override
    @Transactional
    public boolean update(CapabilityIdentity id, CapabilityStorageItem item) {
        this.postCommitEvent(() -> new CapabilityStorageItemUpdatedEventImpl((CapabilityStorageItemData)item));
        ((HasEntityId)item).setId(CapabilityStorageImpl.entityId(id));
        return ((CapabilityStorageItemDAO)this.dao()).update((CapabilityStorageItemData)item);
    }

    @Override
    @Transactional
    public boolean remove(CapabilityIdentity id) {
        this.getAll().values().stream().filter(capability -> id.equals((Object)CapabilityStorageImpl.capabilityIdentity(capability))).findFirst().map(CapabilityStorageItemData.class::cast).ifPresent(item -> this.postCommitEvent(() -> new CapabilityStorageItemDeletedEventImpl((CapabilityStorageItemData)item)));
        return ((CapabilityStorageItemDAO)this.dao()).delete(CapabilityStorageImpl.entityId(id));
    }

    @Override
    @Transactional
    public Map<CapabilityIdentity, CapabilityStorageItem> getAll() {
        return (Map)Streams.stream((Iterable)((CapabilityStorageItemDAO)this.dao()).browse()).collect(ImmutableMap.toImmutableMap(CapabilityStorageImpl::capabilityIdentity, Function.identity()));
    }

    @Override
    @Transactional
    public Map<CapabilityStorageItem, List<CapabilityIdentity>> browseCapabilityDuplicates() {
        return this.getAll().entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue)).entrySet().stream().filter(f -> ((List)f.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(Map.Entry::getKey).collect(Collectors.toList())));
    }

    @Override
    public boolean isDuplicatesFound() {
        Map<CapabilityStorageItem, List<CapabilityIdentity>> duplicates = this.browseCapabilityDuplicates();
        this.log.debug("Found {} capability duplicates", (Object)duplicates.size());
        return !duplicates.isEmpty();
    }

    public static CapabilityIdentity capabilityIdentity(CapabilityStorageItem item) {
        return new CapabilityIdentity(((HasEntityId)item).getId().getValue());
    }

    private static EntityId entityId(CapabilityIdentity id) {
        return new EntityUUID(UUID.fromString(id.toString()));
    }
}

