/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.capability;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.inject.assistedinject.Assisted;
import javax.inject.Inject;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.capability.CapabilityContextAware;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.capability.Condition;
import org.sonatype.nexus.capability.ConditionEvent;
import org.sonatype.nexus.capability.condition.Conditions;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.internal.capability.DefaultCapabilityReference;

public class ValidityConditionHandler
extends ComponentSupport {
    private final EventManager eventManager;
    private final DefaultCapabilityReference reference;
    private final CapabilityRegistry capabilityRegistry;
    private final Conditions conditions;
    private Condition nexusActiveCondition;
    private Condition validityCondition;

    @Inject
    ValidityConditionHandler(EventManager eventManager, CapabilityRegistry capabilityRegistry, Conditions conditions, @Assisted DefaultCapabilityReference reference) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.capabilityRegistry = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilityRegistry);
        this.conditions = (Conditions)Preconditions.checkNotNull((Object)conditions);
        this.reference = (DefaultCapabilityReference)((Object)Preconditions.checkNotNull((Object)((Object)reference)));
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(ConditionEvent.Satisfied event) {
        if (event.getCondition() == this.nexusActiveCondition) {
            this.bindValidity();
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(ConditionEvent.Unsatisfied event) {
        if (event.getCondition() == this.nexusActiveCondition) {
            this.releaseValidity();
        } else if (event.getCondition() == this.validityCondition) {
            this.reference.disable();
            try {
                this.capabilityRegistry.remove(this.reference.context().id());
            }
            catch (Exception e) {
                this.log.error("Failed to remove capability with id '{}'", (Object)this.reference.context().id(), (Object)e);
            }
        }
    }

    ValidityConditionHandler bind() {
        if (this.nexusActiveCondition == null) {
            this.nexusActiveCondition = this.conditions.nexus().active();
            this.nexusActiveCondition.bind();
            this.eventManager.register((Object)this);
            if (this.nexusActiveCondition.isSatisfied()) {
                this.handle(new ConditionEvent.Satisfied(this.nexusActiveCondition));
            }
        }
        return this;
    }

    ValidityConditionHandler release() {
        if (this.nexusActiveCondition != null) {
            this.handle(new ConditionEvent.Unsatisfied(this.nexusActiveCondition));
            this.eventManager.unregister((Object)this);
            this.nexusActiveCondition.release();
        }
        return this;
    }

    private ValidityConditionHandler bindValidity() {
        if (this.validityCondition == null) {
            try {
                this.validityCondition = this.reference.capability().validityCondition();
                if (this.validityCondition instanceof CapabilityContextAware) {
                    ((CapabilityContextAware)this.validityCondition).setContext(this.reference.context());
                }
            }
            catch (Exception e) {
                this.validityCondition = this.conditions.always("Always satisfied (failed to determine validity condition)");
                this.log.error("Could not get validation condition from capability {} ({}). Considering it as always valid", new Object[]{this.reference.capability(), this.reference.context().id(), e});
            }
            if (this.validityCondition == null) {
                this.validityCondition = this.conditions.always("Always satisfied (capability has no validity condition)");
            }
            this.validityCondition.bind();
        }
        return this;
    }

    private ValidityConditionHandler releaseValidity() {
        if (this.validityCondition != null) {
            this.validityCondition.release();
            this.validityCondition = null;
        }
        return this;
    }

    public String toString() {
        String condition = this.nexusActiveCondition.toString();
        if (this.validityCondition != null) {
            condition = this.validityCondition + " WHEN " + condition;
        }
        return String.format("Watching '%s' condition to validate/invalidate capability '%s (id=%s)'", condition, this.reference.capability(), this.reference.context().id());
    }
}

