/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.capability;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorage;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorageItem;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorageItemData;
import org.sonatype.nexus.supportzip.ExportConfigData;
import org.sonatype.nexus.supportzip.ImportData;
import org.sonatype.nexus.supportzip.datastore.JsonExporter;

@Named(value="capabilityStorageExport")
@Singleton
public class CapabilityStorageExport
extends JsonExporter
implements ExportConfigData,
ImportData {
    private final CapabilityStorage capabilityStorage;

    @Inject
    public CapabilityStorageExport(CapabilityStorage capabilityStorage) {
        this.capabilityStorage = capabilityStorage;
    }

    public void export(File file) throws IOException {
        this.log.debug("Export CapabilityStorage data to {}", (Object)file);
        ArrayList<CapabilityStorageItem> capabilities = new ArrayList<CapabilityStorageItem>(this.capabilityStorage.getAll().values());
        this.exportToJson(capabilities, file);
    }

    public void restore(File file) throws IOException {
        this.log.debug("Restoring CapabilityStorage data from {}", (Object)file);
        this.importFromJson(file, CapabilityStorageItemData.class).forEach(this.capabilityStorage::add);
    }
}

