/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.capability;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.inject.assistedinject.Assisted;
import javax.inject.Inject;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.capability.CapabilityContextAware;
import org.sonatype.nexus.capability.Condition;
import org.sonatype.nexus.capability.ConditionEvent;
import org.sonatype.nexus.capability.condition.Conditions;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.internal.capability.DefaultCapabilityReference;

public class ActivationConditionHandler
extends ComponentSupport {
    private final EventManager eventManager;
    private final DefaultCapabilityReference reference;
    private final Conditions conditions;
    private Condition activationCondition;

    @Inject
    ActivationConditionHandler(EventManager eventManager, Conditions conditions, @Assisted DefaultCapabilityReference reference) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.conditions = (Conditions)Preconditions.checkNotNull((Object)conditions);
        this.reference = (DefaultCapabilityReference)((Object)Preconditions.checkNotNull((Object)((Object)reference)));
    }

    boolean isConditionSatisfied() {
        return this.activationCondition != null && this.activationCondition.isSatisfied();
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(ConditionEvent.Satisfied event) {
        if (event.getCondition() == this.activationCondition) {
            this.reference.activate();
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(ConditionEvent.Unsatisfied event) {
        if (event.getCondition() == this.activationCondition) {
            this.reference.passivate();
        }
    }

    ActivationConditionHandler bind() {
        if (this.activationCondition == null) {
            try {
                Condition capabilityActivationCondition = this.reference.capability().activationCondition();
                if (capabilityActivationCondition == null) {
                    capabilityActivationCondition = this.conditions.always("Capability has no activation condition");
                }
                this.activationCondition = this.conditions.logical().and(new Condition[]{capabilityActivationCondition, this.conditions.nexus().active(), this.conditions.capabilities().capabilityHasNoFailures(), this.conditions.capabilities().capabilityHasNoDuplicates()});
                if (this.activationCondition instanceof CapabilityContextAware) {
                    ((CapabilityContextAware)this.activationCondition).setContext(this.reference.context());
                }
            }
            catch (Exception e) {
                this.activationCondition = this.conditions.never("Failed to determine activation condition");
                this.log.error("Could not get activation condition from capability {} ({}). Considering it as non activatable", new Object[]{this.reference.capability(), this.reference.context().id(), e});
            }
            this.activationCondition.bind();
            this.eventManager.register((Object)this);
        }
        return this;
    }

    ActivationConditionHandler release() {
        if (this.activationCondition != null) {
            this.eventManager.unregister((Object)this);
            this.activationCondition.release();
            this.activationCondition = null;
        }
        return this;
    }

    public String toString() {
        return String.format("Watching '%s' condition to activate/passivate capability '%s (id=%s)'", this.activationCondition, this.reference.capability(), this.reference.context().id());
    }

    public String explainWhyNotSatisfied() {
        return this.isConditionSatisfied() ? null : this.activationCondition.explainUnsatisfied();
    }
}

