/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.atlas.customizers;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.logging.task.TaskLogHome;
import org.sonatype.nexus.supportzip.FileContentSourceSupport;
import org.sonatype.nexus.supportzip.SupportBundle;
import org.sonatype.nexus.supportzip.SupportBundleCustomizer;

@Named
@Singleton
public class ReplicationLogCustomizer
extends ComponentSupport
implements SupportBundleCustomizer {
    public void customize(SupportBundle supportBundle) {
        Instant cutOff = ZonedDateTime.now().minusHours(24L).toInstant();
        this.getReplicationLogsHome().map(File::new).map(f -> this.getChildren((File)f, Collections.singletonList("log"), false)).ifPresent(iterator -> iterator.forEachRemaining(file -> this.updateSupportBundle((File)file, supportBundle, cutOff)));
    }

    private Iterator<File> getChildren(File folder, List<String> extensions, boolean recursive) {
        ArrayList<File> validFiles = new ArrayList<File>();
        if (folder.exists()) {
            File[] children;
            File[] fileArray = children = folder.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isDirectory() && recursive) {
                    Iterator<File> childrenResults = this.getChildren(child, extensions, recursive);
                    childrenResults.forEachRemaining(validFiles::add);
                } else if (this.isValidFileExtension(child, extensions)) {
                    validFiles.add(child);
                }
                ++n2;
            }
        }
        return validFiles.iterator();
    }

    private boolean isValidFileExtension(File child, List<String> extensions) {
        String fileName = child.getName();
        int idx = fileName.lastIndexOf(".");
        if (idx > 0) {
            String extension = fileName.substring(idx + 1);
            return extensions.contains(extension);
        }
        return false;
    }

    private void updateSupportBundle(File file, SupportBundle supportBundle, Instant cutOff) {
        if (Instant.ofEpochMilli(file.lastModified()).isAfter(cutOff)) {
            this.log.debug("adding replication log file '{}'", (Object)file);
            supportBundle.add((SupportBundle.ContentSource)new FileContentSourceSupport(SupportBundle.ContentSource.Type.REPLICATIONLOG, String.format("log/replication/%s", file.getName()), file, SupportBundle.ContentSource.Priority.DEFAULT));
        } else {
            this.log.debug("Skipping replication log file [past 24 hours]: {}", (Object)file);
        }
    }

    @VisibleForTesting
    Optional<String> getReplicationLogsHome() {
        return TaskLogHome.getReplicationLogsHome();
    }
}

