/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.atlas.customizers;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.log.LogManager;
import org.sonatype.nexus.supportzip.GeneratedContentSourceSupport;
import org.sonatype.nexus.supportzip.SupportBundle;
import org.sonatype.nexus.supportzip.SupportBundleCustomizer;

@Named
@Singleton
public class JvmLogCustomizer
extends ComponentSupport
implements SupportBundleCustomizer {
    private static final List<String> SENSITIVE_FIELD_NAMES = Arrays.asList("password", "secret", "token", "sign", "auth", "cred", "key", "pass");
    private final LogManager logManager;

    @Inject
    public JvmLogCustomizer(LogManager logManager) {
        this.logManager = (LogManager)Preconditions.checkNotNull((Object)logManager);
    }

    public void customize(SupportBundle supportBundle) {
        supportBundle.add((SupportBundle.ContentSource)new GeneratedContentSourceSupport(SupportBundle.ContentSource.Type.LOG, "log/jvm.log", SupportBundle.ContentSource.Priority.LOW){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected void generate(File file) {
                File logFile = JvmLogCustomizer.this.logManager.getLogFile("jvm.log");
                if (logFile != null) {
                    try {
                        Throwable throwable = null;
                        Object var4_6 = null;
                        try {
                            BufferedReader reader = new BufferedReader(new FileReader(logFile));
                            try {
                                try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                                    String line;
                                    while ((line = reader.readLine()) != null) {
                                        String redactedLine = this.maybeMaskSensitiveData(line);
                                        writer.write(redactedLine);
                                        writer.newLine();
                                    }
                                }
                                if (reader == null) return;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (reader == null) throw throwable;
                                reader.close();
                                throw throwable;
                            }
                            reader.close();
                            return;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                                throw throwable;
                            } else {
                                if (throwable == throwable3) throw throwable;
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        this.log.debug("Unable to include jvm.log file", (Throwable)e);
                    }
                    return;
                }
                this.log.debug("Not including missing jvm.log file");
            }

            private String maybeMaskSensitiveData(String input) {
                String result = input;
                for (String name : SENSITIVE_FIELD_NAMES) {
                    result = result.replaceAll(String.valueOf(name) + "=\\S*", String.valueOf(name) + "=" + "****");
                }
                return result;
            }
        });
    }
}

