/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.atlas;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.cache.Cache;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.cache.CacheHelper;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.atlas.SystemInformationGenerator;
import org.sonatype.nexus.common.atlas.SystemInformationManager;

@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Named
@Singleton
public class SystemInformationManagerImpl
extends LifecycleSupport
implements SystemInformationManager {
    private static final String CACHE_NAME = "SYSTEM_INFORMATION";
    private static final String SYSTEM_INFO_KEY = "systemInfo";
    private final SystemInformationGenerator systemInformationGenerator;
    private final CacheHelper cacheHelper;
    private final int cacheDurationSec;
    private Cache<String, Map<String, Object>> localCache;

    @Inject
    public SystemInformationManagerImpl(SystemInformationGenerator systemInformationGenerator, CacheHelper cacheHelper, @Named(value="${nexus.system.info.cache.duration:-3600}") @Named(value="${nexus.system.info.cache.duration:-3600}") int cacheDurationSec) {
        this.systemInformationGenerator = (SystemInformationGenerator)Preconditions.checkNotNull((Object)systemInformationGenerator);
        this.cacheHelper = (CacheHelper)Preconditions.checkNotNull((Object)cacheHelper);
        Preconditions.checkState((cacheDurationSec >= 0 ? 1 : 0) != 0, (Object)"Initial cache duration should be positive");
        this.cacheDurationSec = cacheDurationSec;
    }

    protected void doStart() {
        this.maybeCreateCache();
    }

    public Map<String, Object> getSystemInfo() {
        Map systemInfo = (Map)this.localCache.get((Object)SYSTEM_INFO_KEY);
        if (Objects.isNull(systemInfo)) {
            Map<String, Object> report = this.generateReport();
            this.log.debug("Caching system information report into {} cache.", (Object)CACHE_NAME);
            this.localCache.put((Object)SYSTEM_INFO_KEY, report);
            return Collections.unmodifiableMap(report);
        }
        this.log.debug("Getting system information report from {} cache.", (Object)CACHE_NAME);
        return Collections.unmodifiableMap(systemInfo);
    }

    private Map<String, Object> generateReport() {
        Map report = this.systemInformationGenerator.report();
        return report.entrySet().stream().filter(e -> !"nexus-bundles".equals(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    protected void doStop() {
        this.maybeDestroyCache();
    }

    private void maybeCreateCache() {
        if (Objects.isNull(this.localCache)) {
            this.log.debug("Creating {} for system information.", (Object)CACHE_NAME);
            Duration duration = new Duration(TimeUnit.SECONDS, (long)this.cacheDurationSec);
            Factory expiryPolicyFactory = CreatedExpiryPolicy.factoryOf((Duration)duration);
            MutableConfiguration config = new MutableConfiguration().setStoreByValue(false).setExpiryPolicyFactory(expiryPolicyFactory).setManagementEnabled(true).setStatisticsEnabled(true);
            this.localCache = this.cacheHelper.maybeCreateCache(CACHE_NAME, config);
            this.log.debug("Created {} cache for system information", (Object)CACHE_NAME);
        }
    }

    private void maybeDestroyCache() {
        this.cacheHelper.maybeDestroyCache(CACHE_NAME);
    }
}

