/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.atlas;

import com.google.common.base.Preconditions;
import com.google.common.io.CountingOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ByteSize;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.log.SupportZipGeneratorRequest;
import org.sonatype.nexus.common.wonderland.DownloadService;
import org.sonatype.nexus.internal.atlas.FlushableZipOutputStream;
import org.sonatype.nexus.supportzip.SupportBundle;
import org.sonatype.nexus.supportzip.SupportBundleCustomizer;
import org.sonatype.nexus.supportzip.SupportZipGenerator;

@Named
@Singleton
public class SupportZipGeneratorImpl
extends ComponentSupport
implements SupportZipGenerator {
    private final List<SupportBundleCustomizer> bundleCustomizers;
    private final DownloadService downloadService;
    private final ByteSize maxFileSize;
    private final ByteSize maxZipFileSize;

    @Inject
    SupportZipGeneratorImpl(DownloadService downloadService, List<SupportBundleCustomizer> bundleCustomizers, @Named(value="${atlas.supportZipGenerator.maxFileSize:-30mb}") @Named(value="${atlas.supportZipGenerator.maxFileSize:-30mb}") ByteSize maxFileSize, @Named(value="${atlas.supportZipGenerator.maxZipFileSize:-50mb}") @Named(value="${atlas.supportZipGenerator.maxZipFileSize:-50mb}") ByteSize maxZipFileSize) {
        this.bundleCustomizers = (List)Preconditions.checkNotNull(bundleCustomizers);
        this.downloadService = (DownloadService)Preconditions.checkNotNull((Object)downloadService);
        this.maxFileSize = maxFileSize;
        this.log.info("Maximum included file size: {}", (Object)maxFileSize);
        this.maxZipFileSize = maxZipFileSize;
        this.log.info("Maximum ZIP file size: {}", (Object)maxZipFileSize);
    }

    public SupportZipGenerator.Result generate(SupportZipGeneratorRequest request) {
        return this.generate(request, "support-");
    }

    public SupportZipGenerator.Result generate(SupportZipGeneratorRequest request, String prefix) {
        Preconditions.checkNotNull((Object)request);
        this.log.info("Generating support ZIP: {}", (Object)request);
        String uniquePrefix = this.downloadService.uniqueName(prefix);
        try {
            boolean truncated;
            Path file = Files.createTempFile(uniquePrefix, "zip", new FileAttribute[0]);
            this.log.debug("Writing ZIP file: {}", (Object)file);
            Throwable throwable = null;
            Object var7_9 = null;
            try (OutputStream output = Files.newOutputStream(file, StandardOpenOption.WRITE);){
                truncated = this.generate(request, uniquePrefix, output);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            long length = Files.size(file);
            String targetFileName = String.valueOf(uniquePrefix) + ".zip";
            String path = this.downloadService.move(file.toFile(), targetFileName);
            this.log.info("Created support ZIP file: {}", (Object)path);
            return new SupportZipGenerator.Result(truncated, targetFileName, path, length);
        }
        catch (IOException e) {
            this.log.error("Support zip generation failed", (Throwable)e);
            return null;
        }
    }

    public boolean generate(SupportZipGeneratorRequest request, String prefix, OutputStream outputStream) {
        boolean bl;
        block5: {
            List<SupportBundle.ContentSource> sources = null;
            SupportBundle bundle = new SupportBundle();
            try {
                this.bundleCustomizers.forEach(customizer -> {
                    this.log.debug("Customizing bundle with: {}", customizer);
                    customizer.customize(bundle);
                });
                Preconditions.checkState((!bundle.getSources().isEmpty() ? 1 : 0) != 0, (Object)"At least one bundle source must be configured");
                sources = this.filterSources(request, bundle);
                Preconditions.checkState((!sources.isEmpty() ? 1 : 0) != 0, (Object)"At least one content source must be configured");
                List<SupportBundle.ContentSource> preparedSources = sources.stream().map(source -> {
                    this.log.debug("Preparing bundle source: {}", source);
                    try {
                        source.prepare();
                        return source;
                    }
                    catch (Exception e) {
                        this.log.error("Failed to prepare source {}", source.getClass(), (Object)e);
                        return null;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toList());
                bl = new ZipCreator(outputStream, preparedSources, prefix, request.isLimitFileSizes(), request.isLimitZipSize()).createZip();
                if (sources == null) break block5;
            }
            catch (Exception e) {
                block6: {
                    try {
                        this.log.error("Failed to create support ZIP", (Throwable)e);
                        if (sources == null) break block6;
                    }
                    catch (Throwable throwable) {
                        if (sources != null) {
                            sources.forEach(source -> {
                                this.log.debug("Cleaning bundle source: {}", source);
                                try {
                                    source.cleanup();
                                }
                                catch (Exception e) {
                                    this.log.warn("Bundle source cleanup failed", (Throwable)e);
                                }
                            });
                        }
                        throw throwable;
                    }
                    sources.forEach(source -> {
                        this.log.debug("Cleaning bundle source: {}", source);
                        try {
                            source.cleanup();
                        }
                        catch (Exception e) {
                            this.log.warn("Bundle source cleanup failed", (Throwable)e);
                        }
                    });
                }
                return false;
            }
            sources.forEach(source -> {
                this.log.debug("Cleaning bundle source: {}", source);
                try {
                    source.cleanup();
                }
                catch (Exception e) {
                    this.log.warn("Bundle source cleanup failed", (Throwable)e);
                }
            });
        }
        return bl;
    }

    private static Set<SupportBundle.ContentSource.Type> includedTypes(SupportZipGeneratorRequest request) {
        HashSet<SupportBundle.ContentSource.Type> types = new HashSet<SupportBundle.ContentSource.Type>();
        if (request.isSystemInformation()) {
            types.add(SupportBundle.ContentSource.Type.SYSINFO);
        }
        if (request.isThreadDump()) {
            types.add(SupportBundle.ContentSource.Type.THREAD);
        }
        if (request.isMetrics()) {
            types.add(SupportBundle.ContentSource.Type.METRICS);
        }
        if (request.isConfiguration()) {
            types.add(SupportBundle.ContentSource.Type.CONFIG);
        }
        if (request.isSecurity()) {
            types.add(SupportBundle.ContentSource.Type.SECURITY);
        }
        if (request.isLog()) {
            types.add(SupportBundle.ContentSource.Type.LOG);
        }
        if (request.isTaskLog()) {
            types.add(SupportBundle.ContentSource.Type.TASKLOG);
        }
        if (request.isAuditLog()) {
            types.add(SupportBundle.ContentSource.Type.AUDITLOG);
        }
        if (request.isJmx()) {
            types.add(SupportBundle.ContentSource.Type.JMX);
        }
        if (request.isReplication()) {
            types.add(SupportBundle.ContentSource.Type.REPLICATIONLOG);
        }
        return types;
    }

    private List<SupportBundle.ContentSource> filterSources(SupportZipGeneratorRequest request, SupportBundle supportBundle) {
        Set<SupportBundle.ContentSource.Type> include = SupportZipGeneratorImpl.includedTypes(request);
        return supportBundle.getSources().stream().filter(source -> include.contains(source.getType())).peek(source -> this.log.debug("Including content source: {}", source)).collect(Collectors.toList());
    }

    private static int percentCompressed(long compressed, long uncompressed) {
        return (int)(100L - compressed / uncompressed * 100L);
    }

    private class ZipCreator {
        private final OutputStream outputStream;
        private final List<SupportBundle.ContentSource> sources;
        private final String prefix;
        private final boolean limitFileSizes;
        private final boolean limitZipSize;
        private long totalUncompressed;

        public ZipCreator(OutputStream outputStream, List<SupportBundle.ContentSource> sources, String prefix, boolean limitFileSizes, boolean limitZipSize) {
            this.outputStream = outputStream;
            this.sources = sources;
            this.prefix = prefix;
            this.limitFileSizes = limitFileSizes;
            this.limitZipSize = limitZipSize;
        }

        boolean createZip() {
            CountingOutputStream stream = new CountingOutputStream(this.outputStream);
            int maxContentSize = (int)SupportZipGeneratorImpl.this.maxFileSize.toBytes();
            int maxZipSize = (int)(SupportZipGeneratorImpl.this.maxZipFileSize.toBytes() - 8192L);
            AtomicBoolean truncated = new AtomicBoolean(false);
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (FlushableZipOutputStream zip = new FlushableZipOutputStream((OutputStream)stream);){
                    zip.setLevel(-1);
                    zip.setSyncFlush(true);
                    this.addDirectoryEntries(zip);
                    this.sources.sort(Comparator.naturalOrder());
                    this.sources.forEach(source -> {
                        SupportZipGeneratorImpl.this.log.debug("Adding content entry: {} {} bytes", source, (Object)source.getSize());
                        ZipEntry entry = this.addEntry(zip, source.getPath());
                        try {
                            Throwable throwable = null;
                            Object var9_11 = null;
                            try (InputStream input = source.getContent();){
                                int len;
                                boolean isLogFile;
                                boolean bl = isLogFile = source.getType() == SupportBundle.ContentSource.Type.LOG || source.getType() == SupportBundle.ContentSource.Type.TASKLOG || source.getType() == SupportBundle.ContentSource.Type.AUDITLOG;
                                if (isLogFile && this.limitFileSizes && source.getSize() > (long)maxContentSize) {
                                    SupportZipGeneratorImpl.this.log.warn("Truncating source contents; exceeds maximum included file size: {}", (Object)source.getPath());
                                    zip.write("** TRUNCATED **".getBytes());
                                    truncated.set(true);
                                    return;
                                }
                                byte[] buff = new byte[4096];
                                while ((len = input.read(buff)) != -1) {
                                    if (isLogFile && this.limitZipSize && stream.getCount() + (long)len > (long)maxZipSize) {
                                        SupportZipGeneratorImpl.this.log.warn("Truncating source contents; max ZIP size reached: {}", (Object)source.getPath());
                                        zip.write("** TRUNCATED **".getBytes());
                                        truncated.set(true);
                                        break;
                                    }
                                    zip.write(buff, 0, len);
                                    zip.flush();
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception e) {
                            SupportZipGeneratorImpl.this.log.warn("Unable to include {} in bundle, moving onto next file.", (Object)source.getPath(), (Object)e);
                        }
                        this.closeEntry(zip, entry);
                    });
                    if (truncated.get()) {
                        this.addEntry(zip, "truncated");
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            if (SupportZipGeneratorImpl.this.log.isDebugEnabled()) {
                SupportZipGeneratorImpl.this.log.debug("ZIP file (in={} out={}) bytes, compressed: {}%", new Object[]{this.totalUncompressed, stream.getCount(), SupportZipGeneratorImpl.percentCompressed(stream.getCount(), this.totalUncompressed)});
            }
            return truncated.get();
        }

        private ZipEntry addEntry(ZipOutputStream zip, String path) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            try {
                ZipEntry entry = new ZipEntry(String.valueOf(this.prefix) + path);
                zip.putNextEntry(entry);
                return entry;
            }
            catch (IOException e) {
                SupportZipGeneratorImpl.this.log.debug("Failed to create path {}", (Object)path);
                throw new UncheckedIOException(e);
            }
        }

        private void closeEntry(ZipOutputStream zip, ZipEntry entry) {
            try {
                zip.closeEntry();
                if (entry.getSize() > 0L) {
                    if (SupportZipGeneratorImpl.this.log.isDebugEnabled()) {
                        SupportZipGeneratorImpl.this.log.debug("Entry (in={} out={}) bytes, compressed: {}%", new Object[]{entry.getSize(), entry.getCompressedSize(), SupportZipGeneratorImpl.percentCompressed(entry.getCompressedSize(), entry.getSize())});
                    }
                    this.totalUncompressed += entry.getSize();
                }
            }
            catch (IOException e) {
                SupportZipGeneratorImpl.this.log.debug("Failed to close entry {}", (Object)entry);
                throw new UncheckedIOException(e);
            }
        }

        private void addDirectoryEntries(ZipOutputStream zip) {
            this.addEntry(zip, "/");
            TreeSet dirs = new TreeSet();
            this.sources.forEach(it -> {
                List<String> path = Arrays.asList(it.getPath().split("/"));
                if (path.size() > 1) {
                    int i = 1;
                    while (i < path.size()) {
                        dirs.add(path.subList(0, i).stream().collect(Collectors.joining("/")));
                        ++i;
                    }
                }
            });
            dirs.forEach(it -> {
                SupportZipGeneratorImpl.this.log.debug("Adding directory entry: {}", it);
                ZipEntry entry = this.addEntry(zip, String.valueOf(it) + "/");
                this.closeEntry(zip, entry);
            });
        }
    }
}

