/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.group.deploy.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.group.deploy.GroupWriteFacet;
import com.sonatype.nexus.repository.group.deploy.internal.GroupWriteFeature;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.licensing.feature.Feature;
import org.sonatype.licensing.feature.LicenseFeatureVerifier;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.WritePolicy;
import org.sonatype.nexus.repository.group.GroupHandler;
import org.sonatype.nexus.repository.group.GroupWriteDenyException;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.ViewFacet;

@Named(value="groupWriteHandler")
@Singleton
public class GroupWriteHandler
extends GroupHandler {
    private LicenseFeatureVerifier licenseVerifier;
    private GroupWriteFeature groupWriteFeature;

    @Inject
    public GroupWriteHandler(LicenseFeatureVerifier licenseVerifier, GroupWriteFeature groupWriteFeature) {
        this.licenseVerifier = (LicenseFeatureVerifier)Preconditions.checkNotNull((Object)licenseVerifier);
        this.groupWriteFeature = (GroupWriteFeature)((Object)Preconditions.checkNotNull((Object)((Object)groupWriteFeature)));
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        this.licenseVerifier.verifyLicenseAndFeature((Feature)this.groupWriteFeature);
        return this.handleWrite(context);
    }

    private Response handleWrite(Context context) throws Exception {
        WritePolicy writePolicy;
        Repository groupRepository = context.getRepository();
        Optional groupWriteFacet = groupRepository.optionalFacet(GroupWriteFacet.class);
        if (!groupWriteFacet.isPresent()) {
            this.log.warn("This [{}] group repository is not writable, missing GroupWriteFacet", (Object)groupRepository.getName());
            return HttpResponses.notFound();
        }
        Repository repository = ((GroupWriteFacet)groupWriteFacet.get()).getWritableMember();
        if (repository == null) {
            String errorMsg = String.format("Group repository [%s] does not have a writable member associated", groupRepository.getName());
            this.log.debug(errorMsg);
            return HttpResponses.notFound((String)errorMsg);
        }
        NestedAttributesMap attributes = repository.getConfiguration().attributes("storage");
        if (attributes != null && (writePolicy = WritePolicy.valueOf((String)((String)attributes.get("writePolicy")))) == WritePolicy.DENY) {
            String errorMsg = String.format("Group repository member %s is read only", repository.getName());
            throw new GroupWriteDenyException(errorMsg);
        }
        this.log.debug("Sending write request of group {} to {}", (Object)groupRepository.getName(), (Object)repository.getName());
        ViewFacet view = (ViewFacet)repository.facet(ViewFacet.class);
        return view.dispatch(context.getRequest(), context);
    }
}

